% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store-bikedata.R
\name{bike_rm_db}
\alias{bike_rm_db}
\title{Remove SQLite3 database generated with 'store_bikedat()'}
\usage{
bike_rm_db(bikedb)
}
\arguments{
\item{bikedb}{The SQLite3 database containing the bikedata.}
}
\value{
TRUE if \code{bikedb} successfully removed; otherwise FALSE
}
\description{
If no directory is specified the \code{bikedb} argument passed to
\code{store_bikedata}, the database is created in \code{tempdir()}. This
function provides a convenient way to remove the database in such cases by
simply passing the name.
}
\examples{
\dontrun{
data_dir <- tempdir ()
bike_write_test_data (data_dir = data_dir)
# or download some real data!
# dl_bikedata (city = 'la', data_dir = data_dir)
bikedb <- file.path (data_dir, 'testdb')
store_bikedata (data_dir = data_dir, bikedb = bikedb)

bike_rm_test_data (data_dir = data_dir)
bike_rm_db (bikedb)
# don't forget to remove real data!
# file.remove (list.files (data_dir, pattern = '.zip'))
}
}
