% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_MLBM_Binary_functions.R
\name{BinBlocRnd_MLBM}
\alias{BinBlocRnd_MLBM}
\title{BinBlocRnd_MLBM function for binary double data matrix simulation}
\usage{
BinBlocRnd_MLBM(n,J,K,theta)
}
\arguments{
\item{n}{a positive integer specifying the number of expected rows.}

\item{J}{a positive integer specifying the number of expected columns of the first matrix.}

\item{K}{a positive integer specifying the number of expected columns of the second matrix.}

\item{theta}{a list specifying the model parameters:

\code{pi_g}: a vector specifying the row mixing proportions.

\code{rho_h}: a vector specifying the first matrix column mixing proportions.

\code{tau_l}: a vector specifying the second matrix column mixing proportions.

\code{alpha_gh}: a matrix specifying the distribution parameter of the first matrix.

 \code{beta_gl}: a matrix specifying the distribution parameter of the second matrix.}
}
\value{
a list including the arguments:

\code{x}: simulated first  data matrix.
\code{y}: simulated second data matrix.

\code{xrow}: numeric vector specifying row partition.

\code{xcolx}: numeric vector specifying first matrix column partition.

 \code{xcoly}: numeric vector specifying second matrix column partition.
}
\description{
Produce two simulated data matrices generated under the Binary Multiple Latent Block Model.
}
\examples{
require(bikm1)
 set.seed(42)
n=200
J=120
K=120
g=3
h=2
l=2
theta=list()
theta$pi_g=1/g *matrix(1,g,1)
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$alpha_gh=matrix(runif(6),ncol=h)
theta$beta_gl=matrix(runif(6),ncol=l)
data=BinBlocRnd_MLBM(n,J,K,theta)

}
