% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/greedy.R
\name{bins.greedy}
\alias{bins.greedy}
\alias{bins.greedy.impl}
\title{Greedy binning algorithm.}
\usage{
bins.greedy(x, nbins, minpts = floor(0.5 * length(x)/nbins), thresh = 0.8,
  naive = FALSE)

bins.greedy.impl(xval, xtbl, xstp, binsz, nbins, thresh, verbose = F)
}
\arguments{
\item{x}{Vector of numbers.}

\item{nbins}{Target number of bins.}

\item{minpts}{Minimum number of points in a bin. Only used if \code{naive = FALSE}.}

\item{thresh}{Threshold fraction of bin size for the greedy algorithm.
Suppose there's \code{n < binsz} points in the current bin already.
Also suppose that the next value V is represented by \code{m} points, and \code{m + n > binsz}.
Then the algorithm will check if \code{m > thresh * binsz}, and if so, will place the value V into a new bin.
If \code{m} is below the threshold, the points having value V are added to the current bin.}

\item{naive}{When \code{TRUE}, simply calls \code{bins.greedy.impl} with data
derived from \code{x}. Otherwise, makes an extra step of marking the values that
by themselves take a whole bin to force the algorithm to place these values
in a bin separately.}

\item{xval}{Sorted unique values of the data set x. This should be the numeric version of \code{names(xtbl)}.}

\item{xtbl}{Result of a call to \code{table(x)}.}

\item{xstp}{Stopping points; if \code{xstp[i] == TRUE}, the \code{i}-th value can't be merged to the \code{(i-1)}-th one.
\code{xstp[1]} value is ignored.}

\item{binsz}{Target bin size, i.e., the number of points falling into each bin; for example, \code{floor(length(x) / nbins)}}

\item{verbose}{When \code{TRUE}, prints the number of points falling into the bins.}
}
\value{
A list with the following items:
\itemize{
   \item{binlo}{ - The "low" value falling into the bin.}
   \item{binhi}{ - The "high" value falling into the bin.}
   \item{binct}{ - The number of points falling into the bin.}
   \item{xtbl}{ - The result of a call to \code{table(x)}.}
   \item{xval}{ - The sorted unique values of the data points x. Essentially, a numeric version of \code{names(xtbl)}.}
}
}
\description{
\code{bins.greedy} - Wrapper around \code{bins.greedy.impl}. Goes over the
sorted values of \code{x} left to right and fills the bins with the values until
they are about the right size.

\code{bins.greedy.impl} - Implementation of a single-pass binning algorithm that examines sorted data left to right
and builds bins of the target size. The \code{bins.greedy} wrapper around this function provides a less involved interface.
This is not symmetric wrt direction: symmetric distributions may not have symmetric bins if there are multiple points
with the same values. If a single value accounts for more than thresh * binsz points, it will be placed in
a new bin.
}
\seealso{
\code{\link{binr}}, \code{\link{bins}}, \code{\link{bins.quantiles}} \code{\link{bins.optimize}}
}

