\name{pdb2aln}
\alias{pdb2aln}
\title{ Align a PDB structure to an existing alignment }
\description{
  Extract sequence from a PDB object and align it to 
  an existing multiple sequence alignment that you wish 
  keep intact.
}
\usage{
pdb2aln(aln, pdb, id="seq.pdb", aln.id=NULL, file="pdb2aln.fa", \dots)
}
\arguments{
  \item{aln}{ an alignment list object with \code{id} and \code{ali}
    components, similar to that generated by \code{\link{read.fasta}},
    \code{\link{read.fasta.pdb}}, and \code{\link{seqaln}}. }
  \item{pdb}{ the PDB object to be added to \code{aln}. }
  \item{id}{ name for the PDB sequence in the generated new alignment. }
  \item{aln.id}{ id of the sequence in \code{aln} that is close to the 
     sequence from \code{pdb}. }
  \item{file}{ output file name for writing the generated new alignment. }
  \item{\dots}{ additional arguments passed to \code{\link{seqaln}}. }
}
\details{
  The basic effect of this function is to add a PDB sequence to an existing
  alignement. In this case, the function is simply a wrapper of 
  \code{\link{seq2aln}}.

  The more advanced (and also more useful) effect is giving complete mappings
  from the column indices of the original alignment (\code{aln$ali}) to 
  atomic indices of equivalent C-alpha atoms in the \code{pdb}. These mappings
  are stored in the output list (see below 'Value' section). This feature
  is better illustrated in the function \code{\link{pdb2aln.ind}}, which 
  calls \code{pdb2aln} and directly returns atom selections given a set of 
  alignment positions. (See \code{\link{pdb2aln.ind}} for details. ) 

  When \code{aln.id} is provided, the function will do pairwise alignment 
  between the sequence from \code{pdb} and the sequence in \code{aln} 
  with id matching \code{aln.id}. This is the best way to use the
  function if the protein has an identical or very similar sequence 
  to one of the sequences in \code{aln}.
}
\value{
  Return a list object of the class 'fasta' containing three components:
  \item{id}{ sequence names as identifers.}
  \item{ali}{ an alignment character matrix with a row per sequence and
    a column per equivalent aminoacid/nucleotide. }
  \item{ref}{ an integer 2xN matrix, where N is the number of columns of
    the new alignment \code{ali}. The first row contains the column indices of 
    the original alignment \code{aln$ali}. The second row contains atomic 
    indices of equivalent C-alpha atoms in \code{pdb}. Gaps in the new 
    alignement are indicated by NAs. }
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
}
\author{ Xin-Qiu Yao & Barry Grant }
\seealso{ \code{\link{seqaln}}, \code{\link{seq2aln}}, 
   \code{\link{seqaln.pair}}, \code{\link{pdb2aln.ind}}}
\examples{
\dontrun{
##--- Read aligned PDB coordinates (CA only)
aln  <- read.fasta(system.file("examples/kif1a.fa",package="bio3d"))
pdbs <- read.fasta.pdb(aln)

##--- Read PDB coordinate for a new structure (all atoms)
id <- get.pdb("2kin", URLonly=TRUE)
pdb <- read.pdb(id)

# add pdb to the alignment 
naln <- pdb2aln(aln=pdbs, pdb=pdb, id=id)
naln

}

}
\keyword{ utilities }

