% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_quantity.R
\name{get_quantity}
\alias{get_quantity}
\alias{get_quantity.vp}
\alias{get_quantity.list}
\alias{get_quantity.vpts}
\title{Get a quantity of a vertical profile (\code{vp}) or time series of vertical profiles (\code{vpts})}
\usage{
get_quantity(x, quantity)

\method{get_quantity}{vp}(x, quantity = "dens")

\method{get_quantity}{list}(x, quantity = "dens")

\method{get_quantity}{vpts}(x, quantity = "dens")
}
\arguments{
\item{x}{A vp or vpts object.}

\item{quantity}{A profile quantity, one of:
\itemize{
 \item{\code{"height"}}{}
 \item{\code{"u"}}{}
 \item{\code{"v"}}{}
 \item{\code{"w"}}{}
 \item{\code{"ff"}}{}
 \item{\code{"dd"}}{}
 \item{\code{"sd_vvp"}}{}
 \item{\code{"gap"}}{}
 \item{\code{"dbz"}}{}
 \item{\code{"eta"}}{}
 \item{\code{"dens"}}{}
 \item{\code{"DBZH"}}{}
 \item{\code{"n"}}{}
 \item{\code{"n_all"}}{}
 \item{\code{"n_dbz"}}{}
 \item{\code{"n_dbz_all"}}{}
}}
}
\value{
class \code{vp}: a named vector for the requested quantity.

class \code{list}: a list of a named vectors for the requested
quantity.

class \code{vpts}: a (height x time) matrix of the
requested quantity.
}
\description{
Get a quantity of a vertical profile (\code{vp}) or time series of vertical profiles (\code{vpts})
}
\details{
This function grabs any of the data quantities stored in
\link[=summary.vp]{vp} or \link[=summary.vpts]{vpts} objects. See the
documentation of the vertical profile \link[=summary.vp]{vp} class for a
description of each of these quantities.
}
\examples{
# load example profile
data(example_vp)

# extract the animal density ("dens") quantity:
get_quantity(example_vp, "dens")
}
