% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvolfile.R
\name{is.pvolfile}
\alias{is.pvolfile}
\title{Check if a local file is a polar volume (\code{pvol})}
\usage{
is.pvolfile(file, filename = NULL)
}
\arguments{
\item{file}{A string containing a file name.}

\item{filename}{Deprecated argument, use file instead.}
}
\value{
TRUE when \code{file} is a polar volume in readable format,
otherwise FALSE
}
\description{
Checker whether a file is a polar volume in ODIM hdf5 format that can be read with
package \pkg{bioRad}
}
\details{
The function checks whether a hdf5 file provided as input is a polar volume
in ODIM hdf5 format. The function currently evaluates to FALSE for NEXRAD and
IRIS RAW polar volume files.
}
\examples{
# locate example file:
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")

# check that the file is an ODIM hdf5 polar volume:
is.pvolfile(pvolfile) # > TRUE
}
