% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doy_noy.R
\name{doy_noy}
\alias{doy_noy}
\alias{doy}
\alias{noy}
\alias{doy.default}
\alias{noy.default}
\alias{doy.vp}
\alias{noy.vp}
\alias{doy.vpts}
\alias{noy.vpts}
\alias{doy.vpi}
\alias{noy.vpi}
\alias{doy.pvol}
\alias{noy.pvol}
\title{Look up day of year (doy) or night of year (noy)}
\usage{
doy(x, ..., method = "fast")

noy(x, ..., method = "fast")

\method{doy}{default}(x, lon, lat, ..., method = "fast")

\method{noy}{default}(x, lon, lat, ..., method = "fast")

\method{doy}{vp}(x, ..., method = "fast")

\method{noy}{vp}(x, ..., method = "fast")

\method{doy}{vpts}(x, ..., method = "fast")

\method{noy}{vpts}(x, ..., method = "fast")

\method{doy}{vpi}(x, ..., method = "fast")

\method{noy}{vpi}(x, ..., method = "fast")

\method{doy}{pvol}(x, ..., method = "fast")

\method{noy}{pvol}(x, ..., method = "fast")
}
\arguments{
\item{x}{A \code{pvol}, \code{vp}, \code{vpts}, or \code{vpi} object, or a \link[base:as.POSIXlt]{base::as.POSIXct}
datetime.}

\item{...}{Optional lat, lon arguments.}

\item{method}{Method by which to do the time zone lookup. Either \code{fast}
(default) or \code{accurate}. See \link[lutz:tz_lookup_coords]{lutz::tz_lookup_coords}].}

\item{lon}{Numeric. Longitude in decimal degrees.}

\item{lat}{Numeric. Latitude in decimal degrees.}
}
\description{
Returns the day of year (\code{doy}) or night of year (\code{noy}) number for datetimes
and various bioRad objects. The first night of the year is the night with
datetime Jan 01 00:00:00 in the local time zone, so sunset on Jan 1 occurs
on the second night of the year and New Years Eve on Dec 31 occurs on the
first night of the new year.
}
\examples{
# Get day of year of a vp object
noy(example_vp)

# Get night of year of a vp object
noy(example_vp)

# Get night of year of a vpts object
noy(example_vpts)
}
