% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-extension-scm.R
\name{compose_scm_v1.3.0}
\alias{compose_scm_v1.3.0}
\alias{compose_scm}
\title{Compose BioCompute Object - SCM Extension (v1.3.0)}
\usage{
compose_scm_v1.3.0(
  scm_repository = NULL,
  scm_type = c("git", "svn", "hg", "other"),
  scm_commit = NULL,
  scm_path = NULL,
  scm_preview = NULL
)

compose_scm(
  scm_repository = NULL,
  scm_type = c("git", "svn", "hg", "other"),
  scm_commit = NULL,
  scm_path = NULL,
  scm_preview = NULL
)
}
\arguments{
\item{scm_repository}{Character string. Base URL of the SCM repository.}

\item{scm_type}{Character string. Type of SCM database. Must be one of
\code{"git"}, \code{"svn"}, \code{"hg"}, or \code{"other"}.}

\item{scm_commit}{Character string. Revision within the SCM repository.
Should be a repository-wide commit identifier or name of a tag,
but may be a name of a branch.}

\item{scm_path}{Character string. Path from the repository to the
source code referenced. Should not start with \code{/}.}

\item{scm_preview}{Character string. The full URI for the source code
referenced by the BioCompute Object.}
}
\value{
A list of class \code{bco.domain}
}
\description{
Compose BioCompute Object - SCM Extension (v1.3.0)
}
\examples{
scm_repository <- "https://github.com/example/repo"
scm_type <- "git"
scm_commit <- "c9ffea0b60fa3bcf8e138af7c99ca141a6b8fb21"
scm_path <- "workflow/hive-viral-mutation-detection.cwl"
scm_preview <- "https://github.com/example/repo/blob/master/mutation-detection.cwl"

compose_scm(scm_repository, scm_type, scm_commit, scm_path, scm_preview) \%>\% convert_json()
}
