% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_aberrations.R
\name{calculate_aberr}
\alias{calculate_aberr}
\alias{calculate_aberr_power}
\alias{calculate_aberr_mean}
\alias{calculate_aberr_var}
\alias{calculate_aberr_disp_index}
\alias{calculate_aberr_u_value}
\alias{init_aberr_table}
\title{Aberration calculation functions}
\usage{
calculate_aberr_power(data, aberr_prefix = "C", power = 1)

calculate_aberr_mean(X, N)

calculate_aberr_var(X, X2, N)

calculate_aberr_disp_index(mean, var)

calculate_aberr_u_value(X, N, mean, var, assessment_u = 1)

init_aberr_table(data, type = c("count", "case"), aberr_module)
}
\arguments{
\item{data}{Count or case data.}

\item{aberr_prefix}{Prefix of the aberrations in the data.}

\item{power}{Power of aberration.}

\item{X}{Sum of detected aberrations.}

\item{N}{Number of cells analysed.}

\item{X2}{Quadratic sum of detected aberrations.}

\item{mean}{Mean.}

\item{var}{Variance.}

\item{assessment_u}{Expected \eqn{u}-value of the assessment. For a Poisson distribution this should be unity.}

\item{type}{Type of input data. Either "count" and "case".}

\item{aberr_module}{Aberration module.}
}
\description{
Aberration calculation functions
}
