% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/gbFeatureTable-class.R,
%   R/gbRecord-class.R, R/gbRecordList-class.R
\docType{methods}
\name{filter}
\alias{filter}
\alias{select}
\alias{filter,gbFeatureTable-method}
\alias{select,gbFeatureTable-method}
\alias{filter,gbRecord-method}
\alias{select,gbRecord-method}
\alias{filter,gbRecordList-method}
\alias{select,gbRecordList-method}
\title{Return a subset of features or annotations from a GenBank Record}
\usage{
filter(x, ...)

select(x, ...)

\S4method{filter}{gbFeatureTable}(x, ..., .cols = NULL)

\S4method{select}{gbFeatureTable}(x, ..., .cols = NULL)

\S4method{filter}{gbRecord}(x, ..., .cols = NULL)

\S4method{select}{gbRecord}(x, ..., .cols = NULL)

\S4method{filter}{gbRecordList}(x, ..., .cols = NULL)

\S4method{select}{gbRecordList}(x, ..., .cols = NULL)
}
\arguments{
\item{x}{A \sQuote{\code{gbRecord}} or \sQuote{\code{gbFeatureTable}}
instance.}

\item{...}{For \code{filter}: named values that specify the features to select. These are
merged with the values of \code{keys} to create the actual query. See
Details; for \code{select}: see \code{.cols}.}

\item{.cols}{A character vector of \sQuote{\emph{keys}} that specify annotaions
to be returned as a \code{data.frame} from the filtered features. If \code{NULL},
a \sQuote{\code{gbFeatureTable}} is returned.
Supported \sQuote{\emph{keys}} are \dQuote{index} or \dQuote{idx}, \dQuote{start},
tag (e.g., \dQuote{locus_tag}, \dQuote{product}, \dQuote{db_xref}). Specific
\code{db_xref}s can by queried using, e.g. \dQuote{db_xref.GI} or
\dQuote{db_xref.GeneID}.}
}
\value{
Depending on the value of \code{.col} a \code{gbRecordList},
\code{gbRecord}, or\code{gbFeatureTable} or a \code{data.frame}.
}
\description{
\code{filter} returns a subset of features from \code{\linkS4class{gbRecordList}},
\code{\linkS4class{gbRecord}} or \code{\linkS4class{gbFeatureTable}} objects,
based on filters provided as \emph{key}, \emph{range}, or \emph{qualifier} values.

\code{select} returns a specified subset of annotations from GenBank Features
as a \code{data.frame}.
}
\details{
Filters are provided as named values using keywords and/or
\dQuote{\emph{qualifier = value}} pairs:

Permissible keywords are:

\describe{
  \item{index/idx}{
    For example: \code{idx = c(3,4,5,6)}, \code{idx = 100:150},
    \code{index = c(1,12:20)}
  }
  \item{range}{
    For example: \code{range = "10000..25000"},
    \code{range = "..10000,20000..25000"},
    \code{range = "30000.."}
  }
  \item{key}{
    For example: \code{key = "CDS"}, \code{key = c("CDS", "gene")}
  }
  \item{arbitrary qualifiers}{
    For example: \code{product = "ribosomal"}, \code{locus_tag = c("CPSIT_0123",
    "CPSIT_0124", "CPSIT_0125")}, \code{pseudo = TRUE}
  }
}
}
\examples{
load(system.file("extdata", "S_cerevisiae_mito.rda", package = "biofiles"))

## filter all hydrophobic tRNAs from the yeast mitochondrion
hydrophobic <- c("Val", "Ile", "Leu", "Met", "Phe", "Trp", "Cys")
trna <- filter(x, key = "tRNA", product = hydrophobic)

## select start, end, orientation, product, and GeneID
df <- select(trna, "start", "end", "strand", "product", "db_xref.GeneID")
df

## combine the above steps into one
cols <- c("start", "end", "strand", "product", "db_xref.GeneID")
filter(x, key = "tRNA", product = hydrophobic, .cols = cols)

## filter all CDS from position 60,000 bp onward
filter(x, key = "CDS", range = "60000..")
}
