\name{comp2}
\alias{comp2}
\docType{data}
\title{
  Methane Content of Biogas
}
\description{
  Methane content (biogas composition) measurements from 15 batch reactors.
}
\usage{data("comp2")}
\format{
  A data frame with 360 observations on the following 3 variables.
  \describe{
    \item{\code{bottle}}{identification code, a unique value for each reactor in the dataset. A factor with levels \code{1_1}, \code{1_2}, \code{1_3}, \code{2_1}, \code{2_2}, \code{2_2}, ... through \code{5_3}. The first number indicates the sample, the second the replicate.}
    \item{\code{days}}{elapsed time of mass measurements (from reactor setup) in days, a numeric vector.}
    \item{\code{CH4.conc}}{biogas methane content as a mole fraction, excluding water and all other gases other than carbon dioxide, a numeric vector}
  }
}
\details{
  These data are meant to be example data for multiple functions, e.g., \code{\link{interp}}, \code{\link{cumBg}}, or \code{\link{summBg}}.
  Reactors were 500 mL or 1000 mL glass serum bottles with butyl rubber septa and screw caps. 
  Methane and carbon dioxide contents were determined by gas chromatography using a thermal conductivity detector and normalised so methane and carbon dioxide sum to 1.0.
  Data in \code{vol2}, \code{comp2}, and \code{setup2} are from the same reactors.
}
\source{
  Measurements made by Ali Heidarzadeh Vazifehkhoran
}
\examples{
data(comp2)
}
\keyword{datasets}
\concept{biogas}
