% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getDatasets.R
\name{getDatasets}
\alias{getDatasets}
\title{Retrieve All Available Datasets for a BioMart Database}
\usage{
getDatasets(mart)
}
\arguments{
\item{mart}{a character string specifying the database (mart) for which datasets shall be listed.}
}
\description{
This funcion queries the BioMart API and returns a table
storing all available datasets for a selected BioMart databases.
}
\examples{
# search for available datasets
head(getMarts(), 10)

\dontrun{

# choose database: "plants_mart_25" -> these versions vary over time
# and get a table of all available datasets from this BioMart database
head(getDatasets("plants_mart_25"), 10)

}
}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{getMarts}}, \code{\link{getAttributes}}, \code{\link{getFilters}}, \code{\link{organismBM}}, \code{\link{organismFilters}}, \code{\link{organismAttributes}}
}

