% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_FindOptimStat.R
\name{bm_FindOptimStat}
\alias{bm_FindOptimStat}
\alias{bm_CalculateStat}
\alias{get_optim_value}
\title{Calculate the best score according to a given evaluation method}
\usage{
bm_FindOptimStat(
  metric.eval = "TSS",
  obs,
  fit,
  nb.thresh = 100,
  threshold = NULL
)

get_optim_value(metric.eval)

bm_CalculateStat(misc, metric.eval = "TSS")
}
\arguments{
\item{metric.eval}{a \code{character} corresponding to the evaluation metric to be used, must 
be either \code{ROC}, \code{TSS}, \code{KAPPA}, \code{ACCURACY}, \code{BIAS}, \code{POD}, 
\code{FAR}, \code{POFD}, \code{SR}, \code{CSI}, \code{ETS}, \code{HK}, \code{HSS}, \code{OR} 
or \code{ORSS}}

\item{obs}{a \code{vector} of observed values (binary, \code{0} or \code{1})}

\item{fit}{a \code{vector} of fitted values (continuous)}

\item{nb.thresh}{an \code{integer} corresponding to the number of thresholds to be 
tested over the range of fitted values}

\item{threshold}{(\emph{optional, default} \code{NULL}) \cr 
A \code{numeric} corresponding to the threshold used to convert the given data}

\item{misc}{a \code{matrix} corresponding to a contingency table}
}
\value{
A \code{1} row x \code{5} columns \code{data.frame} containing :
\itemize{
  \item{\code{metric.eval}}{ : the chosen evaluation metric}
  \item{\code{cutoff}}{ : the associated cut-off used to transform the continuous values into 
  binary}
  \item{\code{sensitivity}}{ : the sensibility obtained on fitted values with this threshold}
  \item{\code{specificity}}{ : the specificity obtained on fitted values with this threshold}
  \item{\code{best.stat}}{ : the best score obtained for the chosen evaluation metric}
}
}
\description{
This internal \pkg{biomod2} function allows the user to find the threshold to 
convert continuous values into binary ones leading to the best score for a given evaluation 
metric.
}
\details{
\emph{Please refer to \code{\link{BIOMOD_Modeling}} to get more information about these 
evaluation metrics.}

Note that if a value is given to \code{threshold}, no optimisation will be done., and 
only the score for this threshold will be returned.
}
\examples{

## Generate a binary vector
vec.a <- sample(c(0, 1), 100, replace = TRUE)

## Generate a 0-1000 vector (random drawing)
vec.b <- runif(100, min = 0, max = 1000)

## Generate a 0-1000 vector (biased drawing)
BiasedDrawing <- function(x, m1 = 300, sd1 = 200, m2 = 700, sd2 = 200) {
  return(ifelse(x < 0.5, rnorm(1, m1, sd1), rnorm(1, m2, sd2)))
}
vec.c <- sapply(vec.a, BiasedDrawing)
vec.c[which(vec.c < 0)] <- 0
vec.c[which(vec.c > 1000)] <- 1000

## Find optimal threshold for a specific evaluation metric
bm_FindOptimStat(metric.eval = 'TSS', fit = vec.b, obs = vec.a)
bm_FindOptimStat(metric.eval = 'TSS', fit = vec.c, obs = vec.a, nb.thresh = 100)
bm_FindOptimStat(metric.eval = 'TSS', fit = vec.c, obs = vec.a, threshold = 280)


}
\seealso{
\code{\link{BIOMOD_Modeling}}, \code{\link{bm_RunModelsLoop}}, 
\code{\link{BIOMOD_EnsembleModeling}}

Other Secundary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CVnnet}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secundary functions}
\keyword{evaluation}
\keyword{models}
\keyword{options}
