% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultAnalytics.R
\name{resultAnalytics}
\alias{resultAnalytics}
\title{Image Summary}
\usage{
resultAnalytics(unfiltered, coordinates, size, img, parallel = FALSE)
}
\arguments{
\item{unfiltered}{all coordinates from every object before applying filter functions}

\item{coordinates}{all filtered coordinates of the objects (x|y|value data frame)}

\item{size}{size of the objects}

\item{img}{image (import by \code{\link[imager]{load.image}})}

\item{parallel}{if TRUE uses multiple cores (75 \%) to process results}
}
\value{
list of 2 objects:
\enumerate{
\item summary of all the microbeads in the image
\item detailed information about every single bead
}
}
\description{
Extracts all important information of the remaining microbeads. This function
summarizes the data obtained by previous functions: objectDetection,
proximityFilter and sizeFilter. Provides information like amount, intensity,
size and density.
}
\examples{
res_objectDetection <- objectDetection(beads, alpha = 1, sigma = 2)
res_sizeFilter <- sizeFilter(
  res_objectDetection$centers,
  res_objectDetection$coordinates,
  lowerlimit = 50, upperlimit = 150
  )
res_proximityFilter <- proximityFilter(
  res_sizeFilter$centers,
  res_objectDetection$coordinates,
  radius = "auto"
  )
res_resultAnalytics <- resultAnalytics(
  unfiltered = res_objectDetection$coordinates,
  coordinates = res_proximityFilter$coordinates,
  size = res_proximityFilter$size,
  img = beads
  )
plot(beads)
with(
  res_objectDetection$centers,
  points(
    res_objectDetection$centers$mx,
    res_objectDetection$centers$my,
    col = "red",
    pch = 19
    )
  )
with(
  res_resultAnalytics$detailed,
  points(
    res_resultAnalytics$detailed$x,
    res_resultAnalytics$detailed$y,
    col = "darkgreen",
    pch = 19
    )
  )
}
