\name{robustness}

\alias{robustness}

\title{ Robustness to species extinctions
}

\description{
Calculates the area below the extinction curve generated by \code{second.extinct}.
}

\usage{
robustness(object)
}


\arguments{
  \item{object}{An object of type class \code{bipartite}, usually generated by \code{\link{second.extinct}}.}
}

\details{
This function calculates the area below the extinction curve generated by second.extinct as a measure of the robustness of the system to the loss of species.

The curve, first proposed by Memmott et al. (2004), is based on the fact that if a given fraction of species of one guild (for instance, the pollinators) are eliminated, a number of species of the other guild (e.g. plants) which depend on their interactions become extinct. The slope and general shape of the curve provided a straightforward graphic description of the tolerance of a system to the extinction of its component species.

An improvement of Memmott et al.'s curve was developed by Burgos et al. (2007) by introducing a quantitative measure of robustness with a single parameter R, defined as the area under the extinction curve. It is intuitive that R = 1 corresponds to a curve that decreases very mildly until the point at which almost all animal species are eliminated. This is consistent with a very robust system in which, for instance, most of the plant species survive even if a large fraction of the animal species is eliminated. Conversely R = 0 corresponds to an ATC that decreases abruptly as soon as any species is lost. This is consistent with a fragile system in which, for instance, even if a very small fraction of the animal species is eliminated, most of the plants loose all their interactions and go extinct.
}

\value{
Returns the robustness of the web to the removal of species.
}

\note{
This index complements the information given by \code{\link{slope.bipartite}}, although it has the advantage of not being constrained by the shape of the particular curve (concave or convex).
}

\references{ 
Burgos, E., H. Ceva, R.P.J. Perazzo, M. Devoto, D. Medan, M. Zimmermann, and A. Maria Delbue (2007) Why nestedness in mutualistic networks? \emph{Journal of Theoretical Biology} \bold{249}, 307--313

Memmott, J., Waser, N. M. and Price, M. V. 2004 Tolerance of pollination networks to species extinctions. \emph{Proceedings of the Royal Society B} \bold{271}, 2605--2611

 }

\author{ Mariano Devoto \email{mdevoto@agro.uba.ar}}

\seealso{ \code{\link{second.extinct}} for generating the required input object and \code{\link{slope.bipartite}} for an alternative, but inferior measure}


\examples{
\dontrun{
data(Safariland)
ex <- second.extinct(Safariland, participant="lower", method="random", nrep=100, 
	details=FALSE)
robustness(ex)
}
}

\keyword{ package }

