% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/words.R
\name{word_pronunciations}
\alias{word_pronunciations}
\title{Retrieve Pronunciations for Words}
\usage{
word_pronunciations(key, words, use_canonical = FALSE, source_dicts = "all",
  pronunciation_type = "all", limit = 50, ...)
}
\arguments{
\item{key}{a Wordnik API key. These can be obtained
at the \href{http://developer.wordnik.com/}{Wordnik developer portal}.}

\item{words}{a vector of words.}

\item{use_canonical}{whether to use the stemmed, canonical form of the word
(i.e. 'cat', for 'cats') instead of the actual \code{word}. FALSE by default.
Note that for pronunciations specifically, setting it to TRUE may get a wider
range of pronunciations; you should experiment.}

\item{source_dicts}{the dictionaries to use; options are any permutation of
"ahd", "century", "wiktionary", "wordnet" and "webster". "all" (the default)
searches all of them.}

\item{pronunciation_type}{the type of pronunciations to return, if available;
options are "ahd", "IPA", "arpabet" and "gcide-diacritical". "all" (the
default) provides any that are available.}

\item{limit}{the maximum number of items to return for any one word.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
\code{word_pronunciations} grabs, well,
pronunciations for a series of words.
}
\examples{
\dontrun{
cats_vs_dogs <- word_pronunciations(key = "fakekey", words = c("cat", "dog"))
}
}
