% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{assess_NB}
\alias{assess_NB}
\title{Assess whether it is possible to use the Poisson model instead of the Negative Binomial (NB) model}
\usage{
assess_NB(
  x,
  stochastic = FALSE,
  numRep = 100,
  cutoff = 0.05,
  plot = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A birp object, estimated under a negative binomial model.}

\item{stochastic}{A boolean indicating if deterministic (default) or stochastic trend model should be used}

\item{numRep}{The number of replicates to run}

\item{cutoff}{The fraction of replicates for which b_Pois > b_x}

\item{plot}{A boolean indicating if the distribution of b should be plotted.}

\item{verbose}{Logical. If \code{FALSE}, the console output is suppressed}
}
\value{
A list. If keepNB is TRUE, the data is overdispersed and the negative binomial model should be used to account for the overdispersion. If keepNB is FALSE, birp should be re-run using the Poisson model to gain power.
}
\description{
Assess whether it is possible to use the Poisson model instead of the Negative Binomial (NB) model
}
\examples{
data <- simulate_birp()
est <- birp(data, negativeBinomial = TRUE)
res_assess <- assess_NB(est, numRep = 5)
}
