% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{simulate_birp_from_results}
\alias{simulate_birp_from_results}
\title{This function simulates a birp_data object using all parameter estimates, dimensionality (methods, locations, timepoints) and the total number of counts nu_ij of a birp object}
\usage{
simulate_birp_from_results(
  x,
  negativeBinomial = FALSE,
  stochastic = FALSE,
  mu = NULL,
  b = NULL,
  logSigma = NULL,
  logPhi = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{An object of type \code{birp}.}

\item{negativeBinomial}{Logical; if \code{TRUE}, simulate counts using a negative binomial distribution instead of Poisson.}

\item{stochastic}{Logical; if \code{TRUE}, use a stochastic model with log-normal fluctuations.}

\item{mu}{A numeric vector specifying values of \eqn{\mu} for the negative binomial model, with one value per method-location combination. If \code{NULL}, \eqn{\mu_i} for method \eqn{i} is set to \eqn{1 / \text{number of locations}}.}

\item{b}{A numeric vector specifying values of \eqn{b} for the negative binomial model (one per method). If \code{NULL}, all \eqn{b_i} are set to 1.}

\item{logSigma}{A single numeric value specifying \code{logSigma} for the stochastic model. If \code{NULL}, \code{logSigma} is set to -1.}

\item{logPhi}{A numeric vector specifying values of \code{logPhi} for the stochastic model. If \code{NULL}, values are simulated according to the model assumptions.}

\item{verbose}{Logical; if \code{FALSE}, suppresses console output.}
}
\value{
An object of type \link{birp_data}
}
\description{
This function simulates a birp_data object using all parameter estimates, dimensionality (methods, locations, timepoints) and the total number of counts nu_ij of a birp object
}
\examples{
data  <- simulate_birp()
x <- birp(data)
data2 <- simulate_birp_from_results(x)
}
