% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{bisect_supervised}
\alias{bisect_supervised}
\title{Add together two numbers.}
\usage{
bisect_supervised(methylation, total_reads, reference, alpha = NA,
  iterations = 200)
}
\arguments{
\item{methylation}{a matrix of individuals (rows) on sites (columns), containing the number of methylated reads for each site, in each individual.}

\item{total_reads}{a matrix of individuals (rows) on sites (columns), containing the total number of reads for each site, in each individual.}

\item{reference}{a matrix of sites (rows) on cell types (columns), containing the probability for methylation in each site, in each cell type.}

\item{alpha}{a vector containing the hyper-parameters for the dirichelt prior. One value for each cell type. If NA, it is initiallized to 1/(number of cell types).}

\item{iterations}{the number of iterations to use in the EM algorithm.}
}
\value{
A matrix of individuals (rows) on cell types (columns) containing the estimated proportion of each cell type, in each individual.
}
\description{
Add together two numbers.
}
\examples{
## Prepare the methylation and total reads matrices
methylation <- as.matrix(methylation_GSE40279)
total_reads <- as.matrix(total_reads_GSE40279)
## Remove the IDs column from the reference
Pi <- as.matrix(reference_blood[,-1])

## Run Bisect. You should use around 200 iterations. I choose than to accelarate the example.
results <- bisect_supervised(methylation, total_reads, Pi, alpha_blood, iterations = 10)
}
