% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_shadow.R
\name{bm_shadow}
\alias{bm_shadow}
\alias{bm_bold}
\alias{bm_glow}
\title{Bitmap shadow, bold, and glow effects}
\usage{
bm_shadow(
  bm_object,
  value = 2L,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

bm_bold(
  bm_object,
  value = 1L,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  extend = TRUE
)

bm_glow(bm_object, value = 2L, extend = TRUE, corner = FALSE)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{value}{The integer value for the shadow, bold, or glow effect.}

\item{top}{How many pixels above should the shadow go.}

\item{right}{How many pixels right should the shadow go.
if \code{top}, \code{right}, \code{bottom}, and \code{left} are all \code{NULL} then defaults to \code{1L}.}

\item{bottom}{How many pixels below should the shadow go.
if \code{top}, \code{right}, \code{bottom}, and \code{left} are all \code{NULL}
then defaults to \code{1L} for \code{bm_shadow()} and \code{0L} for \code{bm_embolden()}.}

\item{left}{How many pixels left should the shadow go.}

\item{extend}{Make the bitmap larger to give the new glyph more "room".}

\item{corner}{Fill in the corners.}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_shadow()} adds a basic "shadow" effect to the bitmap(s).
\code{bm_bold()} is a variant with different defaults to create a basic "bold" effect.
\code{bm_glow()} adds a basic "glow" effect to the bitmap(s).
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r, px = px_ascii)
 print(bm_shadow(capital_r), px = px_ascii)
 print(bm_bold(capital_r), px = px_ascii)
 print(bm_glow(capital_r), px = px_ascii)
 print(bm_glow(capital_r, corner = TRUE), px = px_ascii)

}
\seealso{
\code{\link[=bm_extend]{bm_extend()}} and \code{\link[=bm_shift]{bm_shift()}}
}
