% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_clamp.R
\name{bm_clamp}
\alias{bm_clamp}
\title{Clamp bitmap integer values.}
\usage{
bm_clamp(bm_object, lower = 0L, upper = 1L, value = upper)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}

\item{lower}{Integer value.  Any value below \code{lower} will be clamped.}

\item{upper}{Integer value.  Any value above \code{upper} will be clamped.}

\item{value}{Integer vector of length one or two of replacement value(s).
If \code{value} is length one
any values above \code{upper} are replaced by \code{value}
while those below \code{lower} are replaced by \code{lower}.
If \code{value} is length two any values above \code{upper}
are replaced by \code{value[2]} and any values below \code{lower}
are replaced by \code{value[1]}.}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_clamp()} \dQuote{clamps} bitmap integers that lie outside an interval.
The default coerces a multiple-integer-valued bitmap
into a binary bitmap (as expected by most bitmap font formats).
}
\examples{
 plus_sign <- matrix(0L, nrow = 9L, ncol = 9L)
 plus_sign[5L, 3:7] <- 2L
 plus_sign[3:7, 5L] <- 2L
 plus_sign_glyph <- bm_bitmap(plus_sign)
 print(plus_sign_glyph, px = c(".", "#", "@"))

 plus_sign_clamped <- bm_clamp(plus_sign_glyph)
 print(plus_sign_clamped, px = c(".", "#", "@"))
}
