% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_outline.R
\name{bm_outline}
\alias{bm_outline}
\title{Compute "outline" bitmap of a bitmap}
\usage{
bm_outline(bm_object)
}
\arguments{
\item{bm_object}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}},  or \code{\link[=bm_font]{bm_font()}} object.}
}
\value{
Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_list]{bm_list()}}, or \code{\link[=bm_font]{bm_font()}} object.
}
\description{
\code{bm_outline()} returns a bitmap that is just the \dQuote{outline}
of another bitmap.
}
\examples{
  square <- bm_bitmap(matrix(1L, nrow = 16L, ncol = 16L))
  square_outline <- bm_outline(square)
  print(square_outline, px = px_ascii)

  if (require(grid) && capabilities("png")) {
    circle <- as_bm_bitmap(circleGrob(), width=16, height=16)
    circle_outline <- bm_outline(circle)
    print(circle_outline, px = px_ascii)
  }
}
