% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calendar.R
\name{adjust.date}
\alias{adjust.date}
\alias{adjust.next}
\alias{adjust.previous}
\title{Adjusts the given dates to the next/previous business day}
\usage{
adjust.next(dates, cal = bizdays.options$get("default.calendar"))

adjust.previous(dates, cal = bizdays.options$get("default.calendar"))
}
\arguments{
\item{dates}{dates to be adjusted}

\item{cal}{an instance of \code{Calendar}}
}
\value{
\code{Date} objects adjusted accordingly.
}
\description{
If the given dates are business days it returns the given dates, but once it
is not, it returns the next/previous business days.
}
\section{Date types accepted}{


The argument \code{dates} accepts \code{Date} objects and any
object that returns a valid \code{Date} object when passed through
\code{as.Date}, which include all \code{POSIX*} classes and \code{character}
objects with ISO formatted dates.
}
\examples{
data(holidaysANBIMA)
cal <- Calendar(holidaysANBIMA, weekdays=c("saturday", "sunday"))
adjust.next("2013-01-01", cal)
adjust.previous("2013-01-01", cal)
}

