% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvestigatePrior_rm.R
\name{InvestigatePrior}
\alias{InvestigatePrior}
\title{Investigate prior}
\usage{
InvestigatePrior(y, Z, X, ngrid = 50, q.seq = c(2, 1, 1/2, 1/4, 1/8, 1/16),
  r.seq = NULL, Drange = NULL, verbose = FALSE)
}
\arguments{
\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{ngrid}{Number of grid points over which to plot the exposure-response function}

\item{q.seq}{Sequence of values corresponding to different degrees of smoothness in the estimated exposure-response function. A value of q corresponds to fractions of the range of the data over which there is a decay in the correlation \code{cor(h[i],h[j])} between two subjects by 50\code{\%}.}

\item{r.seq}{sequence of values at which to fix \code{r} for estimating the exposure-response function}

\item{Drange}{the range of the \code{z_m} data over which to apply the values of \code{q.seq}. If not specified, will be calculated as the maximum of the ranges of \code{z_1} through \code{z_M}.}

\item{verbose}{TRUE or FALSE: flag indicating whether to print to the screen which exposure variable and q value has been completed}
}
\description{
Investigate the impact of the \code{r[m]} parameters on the smoothness of the exposure-response function \code{h(z[m])}.
}
\details{
For guided examples, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
