% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simsurvdata.R
\name{simsurvdata}
\alias{simsurvdata}
\title{Simulation of right censored survival times for the Cox model.}
\usage{
simsurvdata(a, b, n, betas, censperc, tmax = NULL)
}
\arguments{
\item{a, b}{The shape parameter `a>0` and scale parameter `b>0`
of the Weibull.}

\item{n}{Sample size.}

\item{betas}{A numeric vector of regression coefficients. Allowed components
of `betas` are in the interval \emph{[-1 ,1]} and the total
number of components cannot exceed 5.}

\item{censperc}{A numeric value in \emph{[0,100]} corresponding to
the targeted percentage of censoring.}

\item{tmax}{A maximum upper bound for the generated latent event times.
Especially useful for a simulation study in which the observed event times
are constrained to be generated in a fixed range.}
}
\value{
An object of class `simsurvdata` which is a list
with the following components:

\item{sample.size}{Sample size.}

\item{censoring}{Censoring scheme. Either \emph{No censoring}
  or \emph{Exponential}.}

\item{num.events}{Number of events.}

\item{censoring.percentage}{The effective censoring percentage.}

\item{survdata}{A data frame containing the simulated data.}

\item{regcoeffs}{The true regression coefficients used to simulate
  the data.}

\item{S0}{The baseline survival function under the chosen Weibull
  parameterization.}

\item{h0}{The baseline hazard function under the chosen Weibull
  parameterization.}

\item{Weibull.mean}{The mean of the Weibull used to generate latent
  event times.}

 \item{Weibull.variance}{The variance of the Weibull used to generate latent
  event times.}

The `print` method summarizes the generated right censored data and
the `plot` method produces a graph with time on the x axis and
horizontal bars on the y axis corresponding either to an event or a
right censored observation. If `n > 25`, only the 25 first observations
are plotted.
}
\description{
Generates right censored time-to-event data. Latent event times are drawn
from a Weibull distribution, while censoring times are generated from an
exponential distribution.
}
\details{
The Weibull baseline hazard is parameterized as follows (see Hamada
  et al. 2008 pp. 408-409) :
  \deqn{h_0(t) = (a/(b^a)) t^(a-1), t > 0.}
  The i\emph{th} latent event time is denoted by \emph{T_i} and is generated
  following Bender et al. (2005) as follows:
  \deqn{T_i = b (-log(U_i) exp(-\beta^T x_i))^(1/a),}
  where \emph{U_i} is a uniform random variable obtained with `runif(1)`
  , \emph{x_i} is the i\emph{th} row of a covariate matrix X of dimension
  `c(n, length(betas))` where each component is generated from a
  standard Gaussian distribution and \eqn{\beta} is the vector of
  regression coefficients given by `betas`.
}
\examples{
set.seed(10)
sim <- simsurvdata(a = 2, b = 1, n = 300, betas = c(0.8, -0.6), censperc = 25)
sim
plot(sim)

}
\references{
Bender, R., Augustin, T. and Blettner, M. (2005). Generating
            survival times to simulate Cox proportional hazards models,
            \emph{Statistics in Medicine} \strong{24}(11): 1713-1723.

Hamada, M. S., Wilson, A., Reese, C. S. and Martz, H. (2008).
           \emph{Bayesian Reliability}. Springer Science and Business Media.
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}.
}
