% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_email_creds_file.R
\name{create_email_creds_file}
\alias{create_email_creds_file}
\title{Create a file with email access credentials}
\usage{
create_email_creds_file(file, sender, host, port, user, password,
  use_ssl = TRUE, use_tls = FALSE, authenticate = TRUE)
}
\arguments{
\item{file}{a file path for the credentials file
to be stored on disk.}

\item{sender}{the sender name.}

\item{host}{the \code{host} name.}

\item{port}{the port number.}

\item{user}{the username for the email account.}

\item{password}{the password associated with the
\code{user}'s email address.}

\item{use_ssl}{an option as to whether to use
SSL; supply a \code{TRUE} or \code{FALSE}
value (\code{TRUE} is the default value).}

\item{use_tls}{a logical value to
indicate whether to use TLS.}

\item{authenticate}{an option as to whether to
authenticate; supply a \code{TRUE} or \code{FALSE}
value (\code{TRUE} is the default value).}
}
\description{
Creates a file with access
credentials for the purpose of automatically
emailing notification messages.
}
\examples{
\dontrun{
# Create a credentials file to facilitate
# the sending of email messages
create_email_creds_file(
  file = "~/.email_file",
  sender = "correspondences@blastula.org",
  host = "smtp.blastula.org",
  port = 465,
  user = "have_a@blastula.org",
  password = "************")
}
}
