% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_blin}
\alias{generate_blin}
\title{Generate data from the continuous BLIN model}
\usage{
generate_blin(S, L, tmax, lag = 1, tau = 1, sigmaY = 1, muAB = 0,
  sigmaAB = 1, rankA = S, rankB = L, use_cov = TRUE, seed = NA,
  sparse = NA)
}
\arguments{
\item{S}{Dimension of A.}

\item{L}{Dimension of B.}

\item{tmax}{Number of observations of relational data.}

\item{lag}{Autoregressive lag in model, defaults to 1.}

\item{tau}{Optional error standard deviatiom, defaults to 1.}

\item{sigmaY}{Optional standard deviation of entries in \eqn{Y_t}, defaults to 1.}

\item{muAB}{Optional mean of entries in decomposition of matrices \eqn{A = UV^T} and \eqn{B = WZ^T}, defaults to 0.}

\item{sigmaAB}{Optional standard deviation of entries in decomposition matrices of \eqn{A = UV^T} and \eqn{B = WZ^T}, defaults to 1.}

\item{rankA}{Rank of influence network matrix \eqn{A}, defaults to full rank.}

\item{rankB}{Optional rank of influence network matrix \eqn{B}, defaults to full rank.}

\item{use_cov}{Optional logical used to indicate whether to include \eqn{X_t \beta} in the model (\code{TRUE}) or not (\code{FALSE}), defaults to \code{TRUE}.}

\item{seed}{Optional numeric to set seed before generating, defaults to NA (no seed set).}

\item{sparse}{Optional degree of sparsity in A and B, i.e. \code{sparsity=.9} means 10\% of the entries in A and B are set to zero at random. Defaults to \code{NA} (no entries set to zero).}
}
\value{
\item{fit}{An \code{blin} object containing summary information.}
}
\description{
This function generates data from the bipartite logitudinal influence network (BLIN) model \eqn{Y_t = A^T \sum_{k=1}^{lag} Y_{t-k} + \sum_{k=1}^{lag} Y_{t-k} B + X_t \beta + \tau E_t}.
}
\details{
This function generates a continuous bipartite longitudinal relational data set from the BLIN model,
 \eqn{Y_t = A^T \sum_{k=1}^{lag} Y_{t-k} + \sum_{k=1}^{lag} Y_{t-k} B + X_t \beta + \tau E_t}, where \eqn{ \{ Y_t \}_t } is a set of \eqn{S \times L} matrices representing the bipartite relational data at each observation \eqn{t}. 
 The set \eqn{\{X_t \}_t} is a set of \eqn{S \times L \times p} arrays describing the influence of the
 coefficient vector \eqn{beta}. Finally, each matrix \eqn{E_t} consists of iid standard normal random variables.
 
 The matrices \eqn{A} and \eqn{B} are square matrices respesenting the influence networks among \eqn{S} senders and \eqn{L} receivers, respectively. The matrix \eqn{A} has decomposition \eqn{A = UV^T}, where each of \eqn{U} and \eqn{V} is an \eqn{S \times {rankA}} matrix of iid standard normal random variables with mean \code{muAB} and standard deviation \code{sigmaAB}. 
 Similarly, the matrix \eqn{B} has decomposition \eqn{B = WZ^T}, where each of \eqn{W} and \eqn{Z} is an \eqn{L \times {rankB}} matrix of iid standard normal random variables with standard deviation \code{sigmaAB} and mean \code{muAB} for \eqn{W} and mean \code{-muAB} for \eqn{Z}. 
 Lastly, the covariate array \eqn{X_t} has 3 covariates: the first is an intercept, the second consists of iid Bernoulli random variables, and the third consists of iid standard normal random variables. All coefficients are \eqn{\beta_i = 0} for \eqn{i = 1,2,3}.
}
\examples{
S <- 5
L <- 4
tmax <- 10
data <- generate_blin(S,L,tmax, lag=2, sparse=.8)
names(data)
dim(data$X)
data$A

}
\seealso{
\code{\link{blin_mle}}
}
\keyword{external}
