% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-fastq_pair.R
\name{fastq_pair}
\alias{fastq_pair}
\alias{fastq_read_pair}
\title{FASTQ PAIR}
\usage{
fastq_pair(
  fq1,
  fq2,
  ...,
  hash_table_size = NULL,
  max_hash_table_size = NULL,
  fastq_pair = NULL
)

fastq_read_pair(fastq_files)
}
\arguments{
\item{fq1, fq2}{A string of fastq file path.}

\item{...}{<\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to \code{fastq_pair} command. Empty arguments are automatically trimmed. If a single argument, such as a file path, contains spaces, it must be quoted, for example using \code{\link{shQuote}}. Details see: \code{cmd_help(fastq_pair())}.}

\item{hash_table_size}{Size of hash table to use.}

\item{max_hash_table_size}{Maximal hash table size to use.}

\item{fastq_pair}{A string of path to \code{fastq_pair} command.}

\item{fastq_files}{A character of the fastq file paths.}
}
\value{
A \code{command} object.
}
\description{
Rewrite paired end fastq files to make sure that all reads have a mate and to
separate out singletons.

Usually when you get paired end read files you have two files with a /1
sequence in one and a /2 sequence in the other (or a /f and /r or just two
reads with the same ID). However, often when working with files from a third
party source (e.g. the SRA) there are different numbers of reads in each file
(because some reads fail QC). Spades, bowtie2 and other tools break because
they demand paired end files have the same number of reads.
}
\seealso{
\url{https://github.com/linsalrob/fastq-pair}
}
