% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_similarity.R
\name{cv_similarity}
\alias{cv_similarity}
\title{Compute similarity measures to evaluate possible extrapolation in testing folds}
\usage{
cv_similarity(
  cv,
  x,
  r,
  num_plot = seq_along(cv$folds_list),
  jitter_width = 0.1,
  points_size = 2,
  points_alpha = 0.7,
  points_colors = NULL,
  progress = TRUE
)
}
\arguments{
\item{cv}{a blockCV cv_* object; a \code{cv_spatial}, \code{cv_cluster}, \code{cv_buffer}
or \code{cv_nndm}}

\item{x}{a simple features (sf) or SpatialPoints object of the spatial sample data used for creating
the \code{cv} object.}

\item{r}{a terra SpatRaster object of environmental predictor that are going to be used for modelling. This
is used to calculate similarity between the training and testing points.}

\item{num_plot}{a vector of indices of folds.}

\item{jitter_width}{numeric; the width of jitter points.}

\item{points_size}{numeric; the size of points.}

\item{points_alpha}{numeric; the opacity of points}

\item{points_colors}{character; a character vector of colours for points}

\item{progress}{logical; whether to shows a progress bar for random fold selection.}
}
\value{
a ggplot object
}
\description{
This function computes multivariate environmental similarity surface (MESS) as described
in Elith et al. (2010). MESS represents how similar a point in a testing fold is to a training
fold (as a reference set of points), with respect to a set of predictor variables in \code{r}.
The negative values are the sites where at least one variable has a value that is outside
the range of environments over the reference set, so these are novel environments.
}
\examples{
\donttest{
library(blockCV)

# import presence-absence species data
points <- read.csv(system.file("extdata/", "species.csv", package = "blockCV"))
# make an sf object from data.frame
pa_data <- sf::st_as_sf(points, coords = c("x", "y"), crs = 7845)

# load raster data
path <- system.file("extdata/au/", package = "blockCV")
files <- list.files(path, full.names = TRUE)
covars <- terra::rast(files)

# hexagonal spatial blocking by specified size and random assignment
sb <- cv_spatial(x = pa_data,
                 column = "occ",
                 size = 450000,
                 k = 5,
                 iteration = 1)

# compute extrapolation
cv_similarity(cv = sb, r = covars, x = pa_data)

}
}
