% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coclusterContinuous.R
\name{coclusterContinuous}
\alias{coclusterContinuous}
\title{Co-Clustering function.}
\usage{
coclusterContinuous(data, semisupervised = FALSE, rowlabels = numeric(0),
  collabels = numeric(0), model = NULL, nbcocluster,
  strategy = coclusterStrategy())
}
\arguments{
\item{data}{Input data as matrix (or list containing data matrix.)}

\item{semisupervised}{Boolean value specifying whether to perform semi-supervised co-clustering or not. Make sure to provide row and/or
column labels if specified value is true. The default value is false.}

\item{rowlabels}{Vector specifying the class of rows. The class number starts from zero. Provide -1 for unknown row class.}

\item{collabels}{Vector specifying the class of columns. The class number starts from zero. Provide -1 for unknown column class.}

\item{model}{This is the name of model. The following models exists for various types of data:
\tabular{rlll}{
    Model  \tab Data-type \tab Proportions \tab Dispersion/Variance \cr
    pik_rhol_sigma2kl(Default) \tab continuous \tab unequal \tab unequal \cr
    pik_rhol_sigma2 \tab continuous \tab unequal \tab equal \cr
    pi_rho_sigma2kl \tab continuous \tab equal \tab unequal \cr
    pi_rho_sigma2 \tab continuous \tab equal \tab equal \cr
}}

\item{nbcocluster}{Integer vector specifying the number of row and column clusters respectively.}

\item{strategy}{Object of class \code{\linkS4class{strategy}}.}
}
\value{
Return an object of \code{\linkS4class{BinaryOptions}} or \code{\linkS4class{ContingencyOptions}}
or \code{\linkS4class{ContinuousOptions}} depending on whether the data-type is Binary, Contingency or Continuous
respectively.
}
\description{
This function performs Co-Clustering (simultaneous clustering of rows and columns )
for continuous data-sets using latent block models. It can also be used to perform
semi-supervised co-clustering.
}
\examples{

# Simple example with simulated continuous data
#load data
data(gaussiandata)
#usage of coclusterContinuous function in its most simplest form
out<-coclusterContinuous(gaussiandata,nbcocluster=c(2,3))
#Summarize the output results
summary(out)
#Plot the original and Co-clustered data 
plot(out)


}

