% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocksdesign-deprecated.R, R/factblocks.r
\name{blocksdesign-deprecated}
\alias{blocksdesign-deprecated}
\alias{factblocks}
\title{Deprecated functions in package \pkg{blocksdesign}.}
\usage{
factblocks(treatments, replicates = 1, rows = NULL, columns = NULL,
  model = NULL, searches = NULL, seed = NULL, jumps = 1)
}
\description{
The functions listed below are deprecated and will be defunct in
  the near future. When possible, alternative functions with similar
  functionality are also mentioned. Help pages for deprecated functions are
  available at \code{help("-deprecated")}.
}
\section{\code{factblocks}}{

For \code{factblocks}, use \code{\link{design}}.
}

\examples{

## The number of searches in the examples have been limited for fast execution. 
## For optimum results, the number of searches may need to be increased in practice.
## Designs should be rebuilt repeatedly to check that a near-optimum design has been found.  


## Factorial designs defined by a treatments data frame and a factorial model equation.

# Main effects of five 2-level factors in a half-fraction of a 4 x 4 row-and column design.
GF = expand.grid(F1=factor(1:2),F2=factor(1:2),F3=factor(1:2),F4=factor(1:2),F5=factor(1:2))
factblocks(treatments=GF,model="~ F1+F2+F3+F4+F5",replicates=.5,rows=4,columns=4,searches=20)


# Second-order model for five qualitative 2-level factors in 4 randomized blocks
GF=expand.grid(F1=factor(1:2),F2=factor(1:2),F3=factor(1:2),F4=factor(1:2),F5=factor(1:2))
factblocks(treatments=GF,model=" ~ (F1+F2+F3+F4+F5)^2",rows=4,searches=5)

# First-order model for 1/3rd fraction of four qualitative 3-level factors in 3  blocks
GF=expand.grid(F1=factor(1:3),F2=factor(1:3),F3=factor(1:3),F4=factor(1:3))
factblocks(treatments=GF,model=" ~ F1+F2+F3+F4",replicates=(1/3),rows=3,searches=5)

# Second-order model for a 1/3rd fraction of five qualitative 3-level factors in 3 blocks
GF=expand.grid( F1=factor(1:3), F2=factor(1:3), F3=factor(1:3), F4=factor(1:3), F5=factor(1:3) )
factblocks(treatments=GF,model=" ~ (F1+F2+F3+F4+F5)^2",rows=3,replicates=(1/3),searches=5)

# Second-order model for two qualitative and two quantitative level factors in 4 randomized blocks
GF=expand.grid(F1=factor(1:2),F2=factor(1:3),V1=1:3,V2=1:4)
modelform=" ~ F1 + F2 + poly(V1,2) +  poly(V2,2) + (poly(V1,1)+F1+F2):(poly(V2,1)+F1+F2) "
\dontrun{factblocks(treatments=GF,model=modelform,rows=4,searches=5)}

# Plackett and Burman design for eleven 2-level factors in 12 runs (needs large number of searches)
GF=expand.grid(F1=factor(1:2),F2=factor(1:2),F3=factor(1:2),F4=factor(1:2),F5=factor(1:2),
F6=factor(1:2),F7=factor(1:2),F8=factor(1:2),F9=factor(1:2),F10=factor(1:2),F11=factor(1:2))
\dontrun{factblocks(GF,model="~ F1+F2+F3+F4+F5+F6+F7+F8+F9+F10+F11",replicates=(12/2048))}


}
\references{
Sailer, M. O. (2013). crossdes: Construction of Crossover Designs. R package version 1.1-1. https://CRAN.R-project.org/package=crossdes

Edmondson R. N. (1998). Trojan square and incomplete Trojan square designs for crop research. Journal of Agricultural Science, Cambridge, 131, pp.135-142

Cochran, W.G., and G.M. Cox. 1957. Experimental Designs, 2nd ed., Wiley, New York.
}
\keyword{internal}
