% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_rsq_mcfadden_adj}
\alias{blr_rsq_mcfadden_adj}
\title{McFadden's adjusted R2}
\usage{
blr_rsq_mcfadden_adj(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
McFadden's adjusted r-squared.
}
\description{
McFadden's adjusted pseudo r-squared for the model.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_rsq_mcfadden_adj(model)

}
\references{
\url{https://eml.berkeley.edu/reprints/mcfadden/zarembka.pdf}
}
\seealso{
Other model fit statistics: \code{\link{blr_model_fit_stats}},
  \code{\link{blr_multi_model_fit_stats}},
  \code{\link{blr_pairs}}, \code{\link{blr_rsq_adj_count}},
  \code{\link{blr_rsq_cox_snell}},
  \code{\link{blr_rsq_effron}},
  \code{\link{blr_rsq_mckelvey_zavoina}},
  \code{\link{blr_rsq_nagelkerke}},
  \code{\link{blr_test_lr}}
}
\concept{model fit statistics}
