% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inflation.R
\name{inflation_adjust}
\alias{inflation_adjust}
\title{Convert the Value of a US Dollar to a Given Year on or before 1913.}
\usage{
inflation_adjust(base_year = NA, ...)
}
\arguments{
\item{base_year}{= A string or integer argument to represent the base year that you would like dollar values converted to. 
For example, if you want to see the value of a 2007 dollar in 2015, you would select 2015 as a base year and find 2007 in the table.}

\item{...}{additional arguments}
}
\value{
A tibble from the BLS API.
}
\description{
Returns a data frame that uses data from the Consumer Price Index (All Goods) to convert the value of a US Dollar [$1.00 USD] over time.
}
\examples{
\dontrun{
## Get historical USD values based on a 2010 dollar.
values <- inflation_adjust(base_year = 2015)
}

}
\keyword{api}
\keyword{bls}
\keyword{cpi}
\keyword{economics}
\keyword{inflation}
\keyword{unemployment}
