
n = 20000

AGE = c("Adolescent", "Adult", "Senior")
SEC = c("Prole", "Middle", "UpperMiddle", "Wealthy")
BOOL = c("True", "False")
RISK = c("Psychopath", "Adventurous", "Normal", "Cautious")
HOME = c("Secure", "City", "Suburb", "Rural")
MIL = c("FiveThou", "TwentyThou", "FiftyThou", "Domino")
YEAR = c("Current", "Older")
MODEL = c("SportsCar", "Economy", "FamilySedan", "Luxury", "SuperLuxury")
SKILL = c("SubStandard", "Normal", "Expert")
VALUE = c("FiveThou", "TenThou", "TwentyThou", "FiftyThou", "Million")
RUGGED = c("EggShell", "Football", "Tank")
SKILL2 = c("Poor", "Normal", "Excellent")
HIST = c("Zero", "One", "Many")
ACC = c("None", "Mild", "Moderate", "Severe")
SKILL3 = c("Poor", "Fair", "Good", "Excellent")
VALUE2 = c("Thousand", "TenThou", "HundredThou", "Million")

Age = sample(AGE, n, prob = c(0.2, 0.6, 0.2), replace = TRUE)
Mileage = sample(MIL, n, prob = c(0.1, 0.4, 0.4, 0.1), replace = TRUE)

SocioEcon = Age
SocioEcon[SocioEcon == "Adolescent"] = sample(SEC, length(which(SocioEcon == "Adolescent")), prob = c(0.4, 0.4, 0.19, 0.01), replace = TRUE)
SocioEcon[SocioEcon == "Adult"] = sample(SEC, length(which(SocioEcon == "Adult")), prob = c(0.4, 0.4, 0.19, 0.01), replace = TRUE)
SocioEcon[SocioEcon == "Senior"] = sample(SEC, length(which(SocioEcon == "Senior")), prob = c(0.5, 0.2, 0.29, 0.01), replace = TRUE)

OtherCar = SocioEcon
OtherCar[OtherCar == "Prole"] = sample(BOOL, length(which(OtherCar == "Prole")), prob = c(0.5, 0.5), replace = TRUE)
OtherCar[OtherCar == "Middle"] = sample(BOOL, length(which(OtherCar == "Middle")), prob = c(0.8, 0.2), replace = TRUE)
OtherCar[OtherCar == "UpperMiddle"] = sample(BOOL, length(which(OtherCar == "UpperMiddle")), prob = c(0.9, 0.1), replace = TRUE)
OtherCar[OtherCar == "Wealthy"] = sample(BOOL, length(which(OtherCar == "Wealthy")), prob = c(0.95, 0.05), replace = TRUE)

GoodStudent = apply(cbind(SocioEcon, Age), 1, paste, collapse = ":")
GoodStudent[GoodStudent == "Prole:Adolescent"] = sample(BOOL, length(which(GoodStudent == "Prole:Adolescent")), prob = c(0.1, 0.9), replace = TRUE)
GoodStudent[GoodStudent == "Prole:Adult"] = sample(BOOL, length(which(GoodStudent == "Prole:Adult")), prob = c(0, 1), replace = TRUE)
GoodStudent[GoodStudent == "Prole:Senior"] = sample(BOOL, length(which(GoodStudent == "Prole:Senior")), prob = c(0, 1), replace = TRUE)
GoodStudent[GoodStudent == "Middle:Adolescent"] = sample(BOOL, length(which(GoodStudent == "Middle:Adolescent")), prob = c(0.2, 0.8), replace = TRUE)
GoodStudent[GoodStudent == "Middle:Adult"] = sample(BOOL, length(which(GoodStudent == "Middle:Adult")), prob = c(0, 1), replace = TRUE)
GoodStudent[GoodStudent == "Middle:Senior"] = sample(BOOL, length(which(GoodStudent == "Middle:Senior")), prob = c(0, 1), replace = TRUE)
GoodStudent[GoodStudent == "UpperMiddle:Adolescent"] = sample(BOOL, length(which(GoodStudent == "UpperMiddle:Adolescent")), prob = c(0.5, 0.5), replace = TRUE)
GoodStudent[GoodStudent == "UpperMiddle:Adult"] = sample(BOOL, length(which(GoodStudent == "UpperMiddle:Adult")), prob = c(0, 1), replace = TRUE)
GoodStudent[GoodStudent == "UpperMiddle:Senior"] = sample(BOOL, length(which(GoodStudent == "UpperMiddle:Senior")), prob = c(0, 1), replace = TRUE)
GoodStudent[GoodStudent == "Wealthy:Adolescent"] = sample(BOOL, length(which(GoodStudent == "Wealthy:Adolescent")), prob = c(0.4, 0.6), replace = TRUE)
GoodStudent[GoodStudent == "Wealthy:Adult"] = sample(BOOL, length(which(GoodStudent == "Wealthy:Adult")), prob = c(0, 1), replace = TRUE)
GoodStudent[GoodStudent == "Wealthy:Senior"] = sample(BOOL, length(which(GoodStudent == "Wealthy:Senior")), prob = c(0, 1), replace = TRUE)

RiskAversion = apply(cbind(Age, SocioEcon), 1, paste, collapse = ":")
RiskAversion[RiskAversion == "Adolescent:Prole"] = sample(RISK, length(which(RiskAversion == "Adolescent:Prole")), prob = c(0.02, 0.58, 0.3, 0.1), replace = TRUE)
RiskAversion[RiskAversion == "Adolescent:Middle"] = sample(RISK, length(which(RiskAversion == "Adolescent:Middle")), prob = c(0.02, 0.38, 0.5, 0.1), replace = TRUE)
RiskAversion[RiskAversion == "Adolescent:UpperMiddle"] = sample(RISK, length(which(RiskAversion == "Adolescent:UpperMiddle")), prob = c(0.02, 0.48, 0.4, 0.1), replace = TRUE)
RiskAversion[RiskAversion == "Adolescent:Wealthy"] = sample(RISK, length(which(RiskAversion == "Adolescent:Wealthy")), prob = c(0.02, 0.58, 0.3, 0.1), replace = TRUE)
RiskAversion[RiskAversion == "Adult:Prole"] = sample(RISK, length(which(RiskAversion == "Adult:Prole")), prob = c(0.015, 0.285, 0.5, 0.2), replace = TRUE)
RiskAversion[RiskAversion == "Adult:Middle"] = sample(RISK, length(which(RiskAversion == "Adult:Middle")), prob = c(0.015, 0.185, 0.6, 0.2), replace = TRUE)
RiskAversion[RiskAversion == "Adult:UpperMiddle"] = sample(RISK, length(which(RiskAversion == "Adult:UpperMiddle")), prob = c(0.015, 0.285, 0.5, 0.2), replace = TRUE)
RiskAversion[RiskAversion == "Adult:Wealthy"] = sample(RISK, length(which(RiskAversion == "Adult:Wealthy")), prob = c(0.015, 0.285, 0.4, 0.3), replace = TRUE)
RiskAversion[RiskAversion == "Senior:Prole"] = sample(RISK, length(which(RiskAversion == "Senior:Prole")), prob = c(0.01, 0.09, 0.4, 0.5), replace = TRUE)
RiskAversion[RiskAversion == "Senior:Middle"] = sample(RISK, length(which(RiskAversion == "Senior:Middle")), prob = c(0.01, 0.04, 0.35, 0.6), replace = TRUE)
RiskAversion[RiskAversion == "Senior:UpperMiddle"] = sample(RISK, length(which(RiskAversion == "Senior:UpperMiddle")), prob = c(0.01, 0.09, 0.4, 0.5), replace = TRUE)
RiskAversion[RiskAversion == "Senior:Wealthy"] = sample(RISK, length(which(RiskAversion == "Senior:Wealthy")), prob = c(0.01, 0.09, 0.4, 0.5), replace = TRUE)

AntiTheft = apply(cbind(RiskAversion, SocioEcon), 1, paste, collapse = ":")
AntiTheft[AntiTheft == "Psychopath:Prole"] = sample(BOOL, length(which(AntiTheft == "Psychopath:Prole")), prob = c(0.000001, 0.999999), replace = TRUE)
AntiTheft[AntiTheft == "Psychopath:Middle"] = sample(BOOL, length(which(AntiTheft == "Psychopath:Middle")), prob = c(0.000001, 0.999999), replace = TRUE)
AntiTheft[AntiTheft == "Psychopath:UpperMiddle"] = sample(BOOL, length(which(AntiTheft == "Psychopath:UpperMiddle")), prob = c(0.05, 0.95), replace = TRUE)
AntiTheft[AntiTheft == "Psychopath:Wealthy"] = sample(BOOL, length(which(AntiTheft == "Psychopath:Wealthy")), prob = c(0.5, 0.5), replace = TRUE)
AntiTheft[AntiTheft == "Adventurous:Prole"] = sample(BOOL, length(which(AntiTheft == "Adventurous:Prole")), prob = c(0.000001, 0.999999), replace = TRUE)
AntiTheft[AntiTheft == "Adventurous:Middle"] = sample(BOOL, length(which(AntiTheft == "Adventurous:Middle")), prob = c(0.000001, 0.999999), replace = TRUE)
AntiTheft[AntiTheft == "Adventurous:UpperMiddle"] = sample(BOOL, length(which(AntiTheft == "Adventurous:UpperMiddle")), prob = c(0.2, 0.8), replace = TRUE)
AntiTheft[AntiTheft == "Adventurous:Wealthy"] = sample(BOOL, length(which(AntiTheft == "Adventurous:Wealthy")), prob = c(0.5, 0.5), replace = TRUE)
AntiTheft[AntiTheft == "Normal:Prole"] = sample(BOOL, length(which(AntiTheft == "Normal:Prole")), prob = c(0.1, 0.9), replace = TRUE)
AntiTheft[AntiTheft == "Normal:Middle"] = sample(BOOL, length(which(AntiTheft == "Normal:Middle")), prob = c(0.3, 0.7), replace = TRUE)
AntiTheft[AntiTheft == "Normal:UpperMiddle"] = sample(BOOL, length(which(AntiTheft == "Normal:UpperMiddle")), prob = c(0.9, 0.1), replace = TRUE)
AntiTheft[AntiTheft == "Normal:Wealthy"] = sample(BOOL, length(which(AntiTheft == "Normal:Wealthy")), prob = c(0.8, 0.2), replace = TRUE)
AntiTheft[AntiTheft == "Cautious:Prole"] = sample(BOOL, length(which(AntiTheft == "Cautious:Prole")), prob = c(0.95, 0.05), replace = TRUE)
AntiTheft[AntiTheft == "Cautious:Middle"] = sample(BOOL, length(which(AntiTheft == "Cautious:Middle")), prob = c(0.999999, 0.000001), replace = TRUE)
AntiTheft[AntiTheft == "Cautious:UpperMiddle"] = sample(BOOL, length(which(AntiTheft == "Cautious:UpperMiddle")), prob = c(0.999999, 0.000001), replace = TRUE)
AntiTheft[AntiTheft == "Cautious:Wealthy"] = sample(BOOL, length(which(AntiTheft == "Cautious:Wealthy")), prob = c(0.999999, 0.000001), replace = TRUE)

HomeBase = apply(cbind(RiskAversion, SocioEcon), 1, paste, collapse = ":")
HomeBase[HomeBase == "Psychopath:Prole"] = sample(HOME, length(which(HomeBase == "Psychopath:Prole")), prob = c(0.000001, 0.8, 0.049999, 0.15), replace = TRUE)
HomeBase[HomeBase == "Psychopath:Middle"] = sample(HOME, length(which(HomeBase == "Psychopath:Middle")), prob = c(0.15, 0.8, 0.04, 0.01), replace = TRUE)
HomeBase[HomeBase == "Psychopath:UpperMiddle"] = sample(HOME, length(which(HomeBase == "Psychopath:UpperMiddle")), prob = c(0.35, 0.6, 0.04, 0.01), replace = TRUE)
HomeBase[HomeBase == "Psychopath:Wealthy"] = sample(HOME, length(which(HomeBase == "Psychopath:Wealthy")), prob = c(0.489999, 0.5, 0.000001, 0.01), replace = TRUE)
HomeBase[HomeBase == "Adventurous:Prole"] = sample(HOME, length(which(HomeBase == "Adventurous:Prole")), prob = c(0.000001, 0.8, 0.05, 0.149999), replace = TRUE)
HomeBase[HomeBase == "Adventurous:Middle"] = sample(HOME, length(which(HomeBase == "Adventurous:Middle")), prob = c(0.01, 0.25, 0.6, 0.14), replace = TRUE)
HomeBase[HomeBase == "Adventurous:UpperMiddle"] = sample(HOME, length(which(HomeBase == "Adventurous:UpperMiddle")), prob = c(0.2, 0.4, 0.3, 0.1), replace = TRUE)
HomeBase[HomeBase == "Adventurous:Wealthy"] = sample(HOME, length(which(HomeBase == "Adventurous:Wealthy")), prob = c(0.95, 0.000001, 0.000001, 0.049998), replace = TRUE)
HomeBase[HomeBase == "Normal:Prole"] = sample(HOME, length(which(HomeBase == "Normal:Prole")), prob = c(0.000001, 0.8, 0.05, 0.149999), replace = TRUE)
HomeBase[HomeBase == "Normal:Middle"] = sample(HOME, length(which(HomeBase == "Normal:Middle")), prob = c(0.299999, 0.000001, 0.6, 0.1), replace = TRUE)
HomeBase[HomeBase == "Normal:UpperMiddle"] = sample(HOME, length(which(HomeBase == "Normal:UpperMiddle")), prob = c(0.5, 0.000001, 0.4, 0.099999), replace = TRUE)
HomeBase[HomeBase == "Normal:Wealthy"] = sample(HOME, length(which(HomeBase == "Normal:Wealthy")), prob = c(0.85, 0.000001, 0.001, 0.148999), replace = TRUE)
HomeBase[HomeBase == "Cautious:Prole"] = sample(HOME, length(which(HomeBase == "Cautious:Prole")), prob = c(0.000001, 0.8, 0.05, 0.149999), replace = TRUE)
HomeBase[HomeBase == "Cautious:Middle"] = sample(HOME, length(which(HomeBase == "Cautious:Middle")), prob = c(0.95, 0.000001, 0.024445, 0.025554), replace = TRUE)
HomeBase[HomeBase == "Cautious:UpperMiddle"] = sample(HOME, length(which(HomeBase == "Cautious:UpperMiddle")), prob = c(0.999997, 0.000001, 0.000001, 0.000001), replace = TRUE)
HomeBase[HomeBase == "Cautious:Wealthy"] = sample(HOME, length(which(HomeBase == "Cautious:Wealthy")), prob = c(0.999997, 0.000001, 0.000001, 0.000001), replace = TRUE)

SeniorTrain = apply(cbind(Age, RiskAversion), 1, paste, collapse = ":")
SeniorTrain[SeniorTrain == "Adolescent:Psychopath"] = sample(BOOL, length(which(SeniorTrain == "Adolescent:Psychopath")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Adolescent:Adventurous"] = sample(BOOL, length(which(SeniorTrain == "Adolescent:Adventurous")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Adolescent:Normal"] = sample(BOOL, length(which(SeniorTrain == "Adolescent:Normal")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Adolescent:Cautious"] = sample(BOOL, length(which(SeniorTrain == "Adolescent:Cautious")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Adult:Psychopath"] = sample(BOOL, length(which(SeniorTrain == "Adult:Psychopath")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Adult:Adventurous"] = sample(BOOL, length(which(SeniorTrain == "Adult:Adventurous")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Adult:Normal"] = sample(BOOL, length(which(SeniorTrain == "Adult:Normal")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Adult:Cautious"] = sample(BOOL, length(which(SeniorTrain == "Adult:Cautious")), prob = c(0, 1), replace = TRUE)
SeniorTrain[SeniorTrain == "Senior:Psychopath"] = sample(BOOL, length(which(SeniorTrain == "Senior:Psychopath")), prob = c(0.000001, 0.999999), replace = TRUE)
SeniorTrain[SeniorTrain == "Senior:Adventurous"] = sample(BOOL, length(which(SeniorTrain == "Senior:Adventurous")), prob = c(0.000001, 0.999999), replace = TRUE)
SeniorTrain[SeniorTrain == "Senior:Normal"] = sample(BOOL, length(which(SeniorTrain == "Senior:Normal")), prob = c(0.3, 0.7), replace = TRUE)
SeniorTrain[SeniorTrain == "Senior:Cautious"] = sample(BOOL, length(which(SeniorTrain == "Senior:Cautious")), prob = c(0.9, 0.1), replace = TRUE)

VehicleYear = apply(cbind(SocioEcon, RiskAversion), 1, paste, collapse = ":")
VehicleYear[VehicleYear == "Prole:Psychopath"] = sample(YEAR, length(which(VehicleYear == "Prole:Psychopath")), prob = c(0.15, 0.85), replace = TRUE)
VehicleYear[VehicleYear == "Prole:Adventurous"] = sample(YEAR, length(which(VehicleYear == "Prole:Adventurous")), prob = c(0.15, 0.85), replace = TRUE)
VehicleYear[VehicleYear == "Prole:Normal"] = sample(YEAR, length(which(VehicleYear == "Prole:Normal")), prob = c(0.15, 0.85), replace = TRUE)
VehicleYear[VehicleYear == "Prole:Cautious"] = sample(YEAR, length(which(VehicleYear == "Prole:Cautious")), prob = c(0.15, 0.85), replace = TRUE)
VehicleYear[VehicleYear == "Middle:Psychopath"] = sample(YEAR, length(which(VehicleYear == "Middle:Psychopath")), prob = c(0.3, 0.7), replace = TRUE)
VehicleYear[VehicleYear == "Middle:Adventurous"] = sample(YEAR, length(which(VehicleYear == "Middle:Adventurous")), prob = c(0.3, 0.7), replace = TRUE)
VehicleYear[VehicleYear == "Middle:Normal"] = sample(YEAR, length(which(VehicleYear == "Middle:Normal")), prob = c(0.3, 0.7), replace = TRUE)
VehicleYear[VehicleYear == "Middle:Cautious"] = sample(YEAR, length(which(VehicleYear == "Middle:Cautious")), prob = c(0.3, 0.7), replace = TRUE)
VehicleYear[VehicleYear == "UpperMiddle:Psychopath"] = sample(YEAR, length(which(VehicleYear == "UpperMiddle:Psychopath")), prob = c(0.8, 0.2), replace = TRUE)
VehicleYear[VehicleYear == "UpperMiddle:Adventurous"] = sample(YEAR, length(which(VehicleYear == "UpperMiddle:Adventurous")), prob = c(0.8, 0.2), replace = TRUE)
VehicleYear[VehicleYear == "UpperMiddle:Normal"] = sample(YEAR, length(which(VehicleYear == "UpperMiddle:Normal")), prob = c(0.8, 0.2), replace = TRUE)
VehicleYear[VehicleYear == "UpperMiddle:Cautious"] = sample(YEAR, length(which(VehicleYear == "UpperMiddle:Cautious")), prob = c(0.8, 0.2), replace = TRUE)
VehicleYear[VehicleYear == "Wealthy:Psychopath"] = sample(YEAR, length(which(VehicleYear == "Wealthy:Psychopath")), prob = c(0.9, 0.1), replace = TRUE)
VehicleYear[VehicleYear == "Wealthy:Adventurous"] = sample(YEAR, length(which(VehicleYear == "Wealthy:Adventurous")), prob = c(0.9, 0.1), replace = TRUE)
VehicleYear[VehicleYear == "Wealthy:Normal"] = sample(YEAR, length(which(VehicleYear == "Wealthy:Normal")), prob = c(0.9, 0.1), replace = TRUE)
VehicleYear[VehicleYear == "Wealthy:Cautious"] = sample(YEAR, length(which(VehicleYear == "Wealthy:Cautious")), prob = c(0.9, 0.1), replace = TRUE)

MakeModel = apply(cbind(SocioEcon, RiskAversion), 1, paste, collapse = ":")
MakeModel[MakeModel == "Prole:Psychopath"] = sample(MODEL, length(which(MakeModel == "Prole:Psychopath")), prob = c(0.1, 0.7, 0.2, 0, 0), replace = TRUE)
MakeModel[MakeModel == "Prole:Adventurous"] = sample(MODEL, length(which(MakeModel == "Prole:Adventurous")), prob = c(0.1, 0.7, 0.2, 0, 0), replace = TRUE)
MakeModel[MakeModel == "Prole:Normal"] = sample(MODEL, length(which(MakeModel == "Prole:Normal")), prob = c(0.1, 0.7, 0.2, 0, 0), replace = TRUE)
MakeModel[MakeModel == "Prole:Cautious"] = sample(MODEL, length(which(MakeModel == "Prole:Cautious")), prob = c(0.1, 0.7, 0.2, 0, 0), replace = TRUE)
MakeModel[MakeModel == "Middle:Psychopath"] = sample(MODEL, length(which(MakeModel == "Middle:Psychopath")), prob = c(0.15, 0.2, 0.65, 0, 0), replace = TRUE)
MakeModel[MakeModel == "Middle:Adventurous"] = sample(MODEL, length(which(MakeModel == "Middle:Adventurous")), prob = c(0.15, 0.2, 0.65, 0, 0), replace = TRUE)
MakeModel[MakeModel == "Middle:Normal"] = sample(MODEL, length(which(MakeModel == "Middle:Normal")), prob = c(0.15, 0.2, 0.65, 0, 0), replace = TRUE)
MakeModel[MakeModel == "Middle:Cautious"] = sample(MODEL, length(which(MakeModel == "Middle:Cautious")), prob = c(0.15, 0.2, 0.65, 0, 0), replace = TRUE)
MakeModel[MakeModel == "UpperMiddle:Psychopath"] = sample(MODEL, length(which(MakeModel == "UpperMiddle:Psychopath")), prob = c(0.2, 0.05, 0.3, 0.45, 0), replace = TRUE)
MakeModel[MakeModel == "UpperMiddle:Adventurous"] = sample(MODEL, length(which(MakeModel == "UpperMiddle:Adventurous")), prob = c(0.2, 0.05, 0.3, 0.45, 0), replace = TRUE)
MakeModel[MakeModel == "UpperMiddle:Normal"] = sample(MODEL, length(which(MakeModel == "UpperMiddle:Normal")), prob = c(0.2, 0.05, 0.3, 0.45, 0), replace = TRUE)
MakeModel[MakeModel == "UpperMiddle:Cautious"] = sample(MODEL, length(which(MakeModel == "UpperMiddle:Cautious")), prob = c(0.2, 0.05, 0.3, 0.45, 0), replace = TRUE)
MakeModel[MakeModel == "Wealthy:Psychopath"] = sample(MODEL, length(which(MakeModel == "Wealthy:Psychopath")), prob = c(0.3, 0.01, 0.09, 0.4, 0.2), replace = TRUE)
MakeModel[MakeModel == "Wealthy:Adventurous"] = sample(MODEL, length(which(MakeModel == "Wealthy:Adventurous")), prob = c(0.3, 0.01, 0.09, 0.4, 0.2), replace = TRUE)
MakeModel[MakeModel == "Wealthy:Normal"] = sample(MODEL, length(which(MakeModel == "Wealthy:Normal")), prob = c(0.3, 0.01, 0.09, 0.4, 0.2), replace = TRUE)
MakeModel[MakeModel == "Wealthy:Cautious"] = sample(MODEL, length(which(MakeModel == "Wealthy:Cautious")), prob = c(0.3, 0.01, 0.09, 0.4, 0.2), replace = TRUE)

DrivingSkill = apply(cbind(Age, SeniorTrain), 1, paste, collapse = ":")
DrivingSkill[DrivingSkill == "Adolescent:True"] = sample(SKILL, length(which(DrivingSkill == "Adolescent:True")), prob = c(0.5, 0.45, 0.05), replace = TRUE)
DrivingSkill[DrivingSkill == "Adolescent:False"] = sample(SKILL, length(which(DrivingSkill == "Adolescent:False")), prob = c(0.5, 0.45, 0.05), replace = TRUE)
DrivingSkill[DrivingSkill == "Adult:True"] = sample(SKILL, length(which(DrivingSkill == "Adult:True")), prob = c(0.3, 0.6, 0.1), replace = TRUE)
DrivingSkill[DrivingSkill == "Adult:False"] = sample(SKILL, length(which(DrivingSkill == "Adult:False")), prob = c(0.3, 0.6, 0.1), replace = TRUE)
DrivingSkill[DrivingSkill == "Senior:True"] = sample(SKILL, length(which(DrivingSkill == "Senior:True")), prob = c(0.1, 0.6, 0.3), replace = TRUE)
DrivingSkill[DrivingSkill == "Senior:False"] = sample(SKILL, length(which(DrivingSkill == "Senior:False")), prob = c(0.4, 0.5, 0.1), replace = TRUE)

CarValue = apply(cbind(MakeModel, VehicleYear, Mileage), 1, paste, collapse = ":")
CarValue[CarValue == "SportsCar:Current:FiveThou"] = sample(VALUE, length(which(CarValue == "SportsCar:Current:FiveThou")), prob = c(0, 0.1, 0.8, 0.09, 0.01), replace = TRUE)
CarValue[CarValue == "SportsCar:Current:TwentyThou"] = sample(VALUE, length(which(CarValue == "SportsCar:Current:TwentyThou")), prob = c(0, 0.1, 0.8, 0.09, 0.01), replace = TRUE)
CarValue[CarValue == "SportsCar:Current:FiftyThou"] = sample(VALUE, length(which(CarValue == "SportsCar:Current:FiftyThou")), prob = c(0, 0.1, 0.8, 0.09, 0.01), replace = TRUE)
CarValue[CarValue == "SportsCar:Current:Domino"] = sample(VALUE, length(which(CarValue == "SportsCar:Current:Domino")), prob = c(0, 0.1, 0.8, 0.09, 0.01), replace = TRUE)
CarValue[CarValue == "SportsCar:Older:FiveThou"] = sample(VALUE, length(which(CarValue == "SportsCar:Older:FiveThou")), prob = c(0.03, 0.3, 0.6, 0.06, 0.01), replace = TRUE)
CarValue[CarValue == "SportsCar:Older:TwentyThou"] = sample(VALUE, length(which(CarValue == "SportsCar:Older:TwentyThou")), prob = c(0.16, 0.5, 0.3, 0.03, 0.01), replace = TRUE)
CarValue[CarValue == "SportsCar:Older:FiftyThou"] = sample(VALUE, length(which(CarValue == "SportsCar:Older:FiftyThou")), prob = c(0.4, 0.47, 0.1, 0.02, 0.01), replace = TRUE)
CarValue[CarValue == "SportsCar:Older:Domino"] = sample(VALUE, length(which(CarValue == "SportsCar:Older:Domino")), prob = c(0.9, 0.06, 0.02, 0.01, 0.01), replace = TRUE)
CarValue[CarValue == "Economy:Current:FiveThou"] = sample(VALUE, length(which(CarValue == "Economy:Current:FiveThou")), prob = c(0.1, 0.8, 0.1, 0, 0), replace = TRUE)
CarValue[CarValue == "Economy:Current:TwentyThou"] = sample(VALUE, length(which(CarValue == "Economy:Current:TwentyThou")), prob = c(0.1, 0.8, 0.1, 0, 0), replace = TRUE)
CarValue[CarValue == "Economy:Current:FiftyThou"] = sample(VALUE, length(which(CarValue == "Economy:Current:FiftyThou")), prob = c(0.1, 0.8, 0.1, 0, 0), replace = TRUE)
CarValue[CarValue == "Economy:Current:Domino"] = sample(VALUE, length(which(CarValue == "Economy:Current:Domino")), prob = c(0.1, 0.8, 0.1, 0, 0), replace = TRUE)
CarValue[CarValue == "Economy:Older:FiveThou"] = sample(VALUE, length(which(CarValue == "Economy:Older:FiveThou")), prob = c(0.25, 0.7, 0.05, 0, 0), replace = TRUE)
CarValue[CarValue == "Economy:Older:TwentyThou"] = sample(VALUE, length(which(CarValue == "Economy:Older:TwentyThou")), prob = c(0.7, 0.2999, 0.0001, 0, 0), replace = TRUE)
CarValue[CarValue == "Economy:Older:FiftyThou"] = sample(VALUE, length(which(CarValue == "Economy:Older:FiftyThou")), prob = c(0.99, 0.009999, 0.000001, 0, 0), replace = TRUE)
CarValue[CarValue == "Economy:Older:Domino"] = sample(VALUE, length(which(CarValue == "Economy:Older:Domino")), prob = c(0.999998, 0.000001, 0.000001, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Current:FiveThou"] = sample(VALUE, length(which(CarValue == "FamilySedan:Current:FiveThou")), prob = c(0, 0.1, 0.9, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Current:TwentyThou"] = sample(VALUE, length(which(CarValue == "FamilySedan:Current:TwentyThou")), prob = c(0, 0.1, 0.9, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Current:FiftyThou"] = sample(VALUE, length(which(CarValue == "FamilySedan:Current:FiftyThou")), prob = c(0, 0.1, 0.9, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Current:Domino"] = sample(VALUE, length(which(CarValue == "FamilySedan:Current:Domino")), prob = c(0, 0.1, 0.9, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Older:FiveThou"] = sample(VALUE, length(which(CarValue == "FamilySedan:Older:FiveThou")), prob = c(0.2, 0.3, 0.5, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Older:TwentyThou"] = sample(VALUE, length(which(CarValue == "FamilySedan:Older:TwentyThou")), prob = c(0.5, 0.3, 0.2, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Older:FiftyThou"] = sample(VALUE, length(which(CarValue == "FamilySedan:Older:FiftyThou")), prob = c(0.7, 0.2, 0.1, 0, 0), replace = TRUE)
CarValue[CarValue == "FamilySedan:Older:Domino"] = sample(VALUE, length(which(CarValue == "FamilySedan:Older:Domino")), prob = c(0.99, 0.009999, 0.000001, 0, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Current:FiveThou"] = sample(VALUE, length(which(CarValue == "Luxury:Current:FiveThou")), prob = c(0, 0, 0, 1, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Current:TwentyThou"] = sample(VALUE, length(which(CarValue == "Luxury:Current:TwentyThou")), prob = c(0, 0, 0, 1, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Current:FiftyThou"] = sample(VALUE, length(which(CarValue == "Luxury:Current:FiftyThou")), prob = c(0, 0, 0, 1, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Current:Domino"] = sample(VALUE, length(which(CarValue == "Luxury:Current:Domino")), prob = c(0, 0, 0, 1, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Older:FiveThou"] = sample(VALUE, length(which(CarValue == "Luxury:Older:FiveThou")), prob = c(0.01, 0.09, 0.2, 0.7, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Older:TwentyThou"] = sample(VALUE, length(which(CarValue == "Luxury:Older:TwentyThou")), prob = c(0.05, 0.15, 0.3, 0.5, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Older:FiftyThou"] = sample(VALUE, length(which(CarValue == "Luxury:Older:FiftyThou")), prob = c(0.1, 0.3, 0.3, 0.3, 0), replace = TRUE)
CarValue[CarValue == "Luxury:Older:Domino"] = sample(VALUE, length(which(CarValue == "Luxury:Older:Domino")), prob = c(0.2, 0.2, 0.3, 0.3, 0), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Current:FiveThou"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Current:FiveThou")), prob = c(0, 0, 0, 0, 1), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Current:TwentyThou"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Current:TwentyThou")), prob = c(0, 0, 0, 0, 1), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Current:FiftyThou"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Current:FiftyThou")), prob = c(0, 0, 0, 0, 1), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Current:Domino"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Current:Domino")), prob = c(0, 0, 0, 0, 1), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Older:FiveThou"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Older:FiveThou")), prob = c(0.000001, 0.000001, 0.000001, 0.000001, 0.999996), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Older:TwentyThou"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Older:TwentyThou")), prob = c(0.000001, 0.000001, 0.000001, 0.000001, 0.999996), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Older:FiftyThou"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Older:FiftyThou")), prob = c(0.000001, 0.000001, 0.000001, 0.000001, 0.999996), replace = TRUE)
CarValue[CarValue == "SuperLuxury:Older:Domino"] = sample(VALUE, length(which(CarValue == "SuperLuxury:Older:Domino")), prob = c(0.000001, 0.000001, 0.000001, 0.000001, 0.999996), replace = TRUE)

RuggedAuto = apply(cbind(MakeModel, VehicleYear), 1, paste, collapse = ":")
RuggedAuto[RuggedAuto == "SportsCar:Current"] = sample(RUGGED, length(which(RuggedAuto == "SportsCar:Current")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
RuggedAuto[RuggedAuto == "SportsCar:Older"] = sample(RUGGED, length(which(RuggedAuto == "SportsCar:Older")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
RuggedAuto[RuggedAuto == "Economy:Current"] = sample(RUGGED, length(which(RuggedAuto == "Economy:Current")), prob = c(0.5, 0.5, 0), replace = TRUE)
RuggedAuto[RuggedAuto == "Economy:Older"] = sample(RUGGED, length(which(RuggedAuto == "Economy:Older")), prob = c(0.9, 0.1, 0), replace = TRUE)
RuggedAuto[RuggedAuto == "FamilySedan:Current"] = sample(RUGGED, length(which(RuggedAuto == "FamilySedan:Current")), prob = c(0.2, 0.6, 0.2), replace = TRUE)
RuggedAuto[RuggedAuto == "FamilySedan:Older"] = sample(RUGGED, length(which(RuggedAuto == "FamilySedan:Older")), prob = c(0.05, 0.55, 0.4), replace = TRUE)
RuggedAuto[RuggedAuto == "Luxury:Current"] = sample(RUGGED, length(which(RuggedAuto == "Luxury:Current")), prob = c(0.1, 0.6, 0.3), replace = TRUE)
RuggedAuto[RuggedAuto == "Luxury:Older"] = sample(RUGGED, length(which(RuggedAuto == "Luxury:Older")), prob = c(0.1, 0.6, 0.3), replace = TRUE)
RuggedAuto[RuggedAuto == "SuperLuxury:Current"] = sample(RUGGED, length(which(RuggedAuto == "SuperLuxury:Current")), prob = c(0.05, 0.55, 0.4), replace = TRUE)
RuggedAuto[RuggedAuto == "SuperLuxury:Older"] = sample(RUGGED, length(which(RuggedAuto == "SuperLuxury:Older")), prob = c(0.05, 0.55, 0.4), replace = TRUE)

Antilock = apply(cbind(MakeModel, VehicleYear), 1, paste, collapse = ":")
Antilock[Antilock == "SportsCar:Current"] = sample(BOOL, length(which(Antilock == "SportsCar:Current")), prob = c(0.9, 0.1), replace = TRUE)
Antilock[Antilock == "SportsCar:Older"] = sample(BOOL, length(which(Antilock == "SportsCar:Older")), prob = c(0.1, 0.9), replace = TRUE)
Antilock[Antilock == "Economy:Current"] = sample(BOOL, length(which(Antilock == "Economy:Current")), prob = c(0.001, 0.999), replace = TRUE)
Antilock[Antilock == "Economy:Older"] = sample(BOOL, length(which(Antilock == "Economy:Older")), prob = c(0, 1), replace = TRUE)
Antilock[Antilock == "FamilySedan:Current"] = sample(BOOL, length(which(Antilock == "FamilySedan:Current")), prob = c(0.4, 0.6), replace = TRUE)
Antilock[Antilock == "FamilySedan:Older"] = sample(BOOL, length(which(Antilock == "FamilySedan:Older")), prob = c(0, 1), replace = TRUE)
Antilock[Antilock == "Luxury:Current"] = sample(BOOL, length(which(Antilock == "Luxury:Current")), prob = c(0.99, 0.01), replace = TRUE)
Antilock[Antilock == "Luxury:Older"] = sample(BOOL, length(which(Antilock == "Luxury:Older")), prob = c(0.3, 0.7), replace = TRUE)
Antilock[Antilock == "SuperLuxury:Current"] = sample(BOOL, length(which(Antilock == "SuperLuxury:Current")), prob = c(0.99, 0.01), replace = TRUE)
Antilock[Antilock == "SuperLuxury:Older"] = sample(BOOL, length(which(Antilock == "SuperLuxury:Older")), prob = c(0.15, 0.85), replace = TRUE)

Airbag = apply(cbind(MakeModel, VehicleYear), 1, paste, collapse = ":")
Airbag[Airbag == "SportsCar:Current"] = sample(BOOL, length(which(Airbag == "SportsCar:Current")), prob = c(1, 0), replace = TRUE)
Airbag[Airbag == "SportsCar:Older"] = sample(BOOL, length(which(Airbag == "SportsCar:Older")), prob = c(0.1, 0.9), replace = TRUE)
Airbag[Airbag == "Economy:Current"] = sample(BOOL, length(which(Airbag == "Economy:Current")), prob = c(1, 0), replace = TRUE)
Airbag[Airbag == "Economy:Older"] = sample(BOOL, length(which(Airbag == "Economy:Older")), prob = c(0.05, 0.95), replace = TRUE)
Airbag[Airbag == "FamilySedan:Current"] = sample(BOOL, length(which(Airbag == "FamilySedan:Current")), prob = c(1, 0), replace = TRUE)
Airbag[Airbag == "FamilySedan:Older"] = sample(BOOL, length(which(Airbag == "FamilySedan:Older")), prob = c(0.2, 0.8), replace = TRUE)
Airbag[Airbag == "Luxury:Current"] = sample(BOOL, length(which(Airbag == "Luxury:Current")), prob = c(1, 0), replace = TRUE)
Airbag[Airbag == "Luxury:Older"] = sample(BOOL, length(which(Airbag == "Luxury:Older")), prob = c(0.6, 0.4), replace = TRUE)
Airbag[Airbag == "SuperLuxury:Current"] = sample(BOOL, length(which(Airbag == "SuperLuxury:Current")), prob = c(1, 0), replace = TRUE)
Airbag[Airbag == "SuperLuxury:Older"] = sample(BOOL, length(which(Airbag == "SuperLuxury:Older")), prob = c(0.1, 0.9), replace = TRUE)

DrivQuality = apply(cbind(DrivingSkill, RiskAversion), 1, paste, collapse = ":")
DrivQuality[DrivQuality == "SubStandard:Psychopath"] = sample(SKILL2, length(which(DrivQuality == "SubStandard:Psychopath")), prob = c(1, 0, 0), replace = TRUE)
DrivQuality[DrivQuality == "SubStandard:Adventurous"] = sample(SKILL2, length(which(DrivQuality == "SubStandard:Adventurous")), prob = c(1, 0, 0), replace = TRUE)
DrivQuality[DrivQuality == "SubStandard:Normal"] = sample(SKILL2, length(which(DrivQuality == "SubStandard:Normal")), prob = c(1, 0, 0), replace = TRUE)
DrivQuality[DrivQuality == "SubStandard:Cautious"] = sample(SKILL2, length(which(DrivQuality == "SubStandard:Cautious")), prob = c(1, 0, 0), replace = TRUE)
DrivQuality[DrivQuality == "Normal:Psychopath"] = sample(SKILL2, length(which(DrivQuality == "Normal:Psychopath")), prob = c(0.5, 0.2, 0.3), replace = TRUE)
DrivQuality[DrivQuality == "Normal:Adventurous"] = sample(SKILL2, length(which(DrivQuality == "Normal:Adventurous")), prob = c(0.3, 0.4, 0.3), replace = TRUE)
DrivQuality[DrivQuality == "Normal:Normal"] = sample(SKILL2, length(which(DrivQuality == "Normal:Normal")), prob = c(0, 1, 0), replace = TRUE)
DrivQuality[DrivQuality == "Normal:Cautious"] = sample(SKILL2, length(which(DrivQuality == "Normal:Cautious")), prob = c(0, 0.8, 0.2), replace = TRUE)
DrivQuality[DrivQuality == "Expert:Psychopath"] = sample(SKILL2, length(which(DrivQuality == "Expert:Psychopath")), prob = c(0.3, 0.2, 0.5), replace = TRUE)
DrivQuality[DrivQuality == "Expert:Adventurous"] = sample(SKILL2, length(which(DrivQuality == "Expert:Adventurous")), prob = c(0.01, 0.01, 0.98), replace = TRUE)
DrivQuality[DrivQuality == "Expert:Normal"] = sample(SKILL2, length(which(DrivQuality == "Expert:Normal")), prob = c(0, 0, 1), replace = TRUE)
DrivQuality[DrivQuality == "Expert:Cautious"] = sample(SKILL2, length(which(DrivQuality == "Expert:Cautious")), prob = c(0, 0, 1), replace = TRUE)

DrivHist = apply(cbind(DrivingSkill, RiskAversion), 1, paste, collapse = ":")
DrivHist[DrivHist == "SubStandard:Psychopath"] = sample(HIST, length(which(DrivHist == "SubStandard:Psychopath")), prob = c(0.001, 0.004, 0.995), replace = TRUE)
DrivHist[DrivHist == "SubStandard:Adventurous"] = sample(HIST, length(which(DrivHist == "SubStandard:Adventurous")), prob = c(0.002, 0.008, 0.99), replace = TRUE)
DrivHist[DrivHist == "SubStandard:Normal"] = sample(HIST, length(which(DrivHist == "SubStandard:Normal")), prob = c(0.03, 0.15, 0.82), replace = TRUE)
DrivHist[DrivHist == "SubStandard:Cautious"] = sample(HIST, length(which(DrivHist == "SubStandard:Cautious")), prob = c(0.3, 0.3, 0.4), replace = TRUE)
DrivHist[DrivHist == "Normal:Psychopath"] = sample(HIST, length(which(DrivHist == "Normal:Psychopath")), prob = c(0.1, 0.3, 0.6), replace = TRUE)
DrivHist[DrivHist == "Normal:Adventurous"] = sample(HIST, length(which(DrivHist == "Normal:Adventurous")), prob = c(0.5, 0.3, 0.2), replace = TRUE)
DrivHist[DrivHist == "Normal:Normal"] = sample(HIST, length(which(DrivHist == "Normal:Normal")), prob = c(0.9, 0.07, 0.03), replace = TRUE)
DrivHist[DrivHist == "Normal:Cautious"] = sample(HIST, length(which(DrivHist == "Normal:Cautious")), prob = c(0.95, 0.04, 0.01), replace = TRUE)
DrivHist[DrivHist == "Expert:Psychopath"] = sample(HIST, length(which(DrivHist == "Expert:Psychopath")), prob = c(0.3, 0.3, 0.4), replace = TRUE)
DrivHist[DrivHist == "Expert:Adventurous"] = sample(HIST, length(which(DrivHist == "Expert:Adventurous")), prob = c(0.6, 0.3, 0.1), replace = TRUE)
DrivHist[DrivHist == "Expert:Normal"] = sample(HIST, length(which(DrivHist == "Expert:Normal")), prob = c(0.99, 0.009999, 0.000001), replace = TRUE)
DrivHist[DrivHist == "Expert:Cautious"] = sample(HIST, length(which(DrivHist == "Expert:Cautious")), prob = c(0.999998, 0.000001, 0.000001), replace = TRUE)

Theft = apply(cbind(AntiTheft, HomeBase, CarValue), 1, paste, collapse = ":")
Theft[Theft == "True:Secure:FiveThou"] = sample(BOOL, length(which(Theft == "True:Secure:FiveThou")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "True:Secure:TenThou"] = sample(BOOL, length(which(Theft == "True:Secure:TenThou")), prob = c(0.000002, 0.999998), replace = TRUE)
Theft[Theft == "True:Secure:TwentyThou"] = sample(BOOL, length(which(Theft == "True:Secure:TwentyThou")), prob = c(0.000003, 0.999997), replace = TRUE)
Theft[Theft == "True:Secure:FiftyThou"] = sample(BOOL, length(which(Theft == "True:Secure:FiftyThou")), prob = c(0.000002, 0.999998), replace = TRUE)
Theft[Theft == "True:Secure:Million"] = sample(BOOL, length(which(Theft == "True:Secure:Million")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "True:City:FiveThou"] = sample(BOOL, length(which(Theft == "True:City:FiveThou")), prob = c(0.0005, 0.9995), replace = TRUE)
Theft[Theft == "True:City:TenThou"] = sample(BOOL, length(which(Theft == "True:City:TenThou")), prob = c(0.002, 0.998), replace = TRUE)
Theft[Theft == "True:City:TwentyThou"] = sample(BOOL, length(which(Theft == "True:City:TwentyThou")), prob = c(0.005, 0.995), replace = TRUE)
Theft[Theft == "True:City:FiftyThou"] = sample(BOOL, length(which(Theft == "True:City:FiftyThou")), prob = c(0.005, 0.995), replace = TRUE)
Theft[Theft == "True:City:Million"] = sample(BOOL, length(which(Theft == "True:City:Million")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "True:Suburb:FiveThou"] = sample(BOOL, length(which(Theft == "True:Suburb:FiveThou")), prob = c(0.00001, 0.99999), replace = TRUE)
Theft[Theft == "True:Suburb:TenThou"] = sample(BOOL, length(which(Theft == "True:Suburb:TenThou")), prob = c(0.0001, 0.9999), replace = TRUE)
Theft[Theft == "True:Suburb:TwentyThou"] = sample(BOOL, length(which(Theft == "True:Suburb:TwentyThou")), prob = c(0.0003, 0.9997), replace = TRUE)
Theft[Theft == "True:Suburb:FiftyThou"] = sample(BOOL, length(which(Theft == "True:Suburb:FiftyThou")), prob = c(0.0003, 0.9997), replace = TRUE)
Theft[Theft == "True:Suburb:Million"] = sample(BOOL, length(which(Theft == "True:Suburb:Million")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "True:Rural:FiveThou"] = sample(BOOL, length(which(Theft == "True:Rural:FiveThou")), prob = c(0.00001, 0.99999), replace = TRUE)
Theft[Theft == "True:Rural:TenThou"] = sample(BOOL, length(which(Theft == "True:Rural:TenThou")), prob = c(0.00002, 0.99998), replace = TRUE)
Theft[Theft == "True:Rural:TwentyThou"] = sample(BOOL, length(which(Theft == "True:Rural:TwentyThou")), prob = c(0.00005, 0.99995), replace = TRUE)
Theft[Theft == "True:Rural:FiftyThou"] = sample(BOOL, length(which(Theft == "True:Rural:FiftyThou")), prob = c(0.00005, 0.99995), replace = TRUE)
Theft[Theft == "True:Rural:Million"] = sample(BOOL, length(which(Theft == "True:Rural:Million")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "False:Secure:FiveThou"] = sample(BOOL, length(which(Theft == "False:Secure:FiveThou")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "False:Secure:TenThou"] = sample(BOOL, length(which(Theft == "False:Secure:TenThou")), prob = c(0.000002, 0.999998), replace = TRUE)
Theft[Theft == "False:Secure:TwentyThou"] = sample(BOOL, length(which(Theft == "False:Secure:TwentyThou")), prob = c(0.000003, 0.999997), replace = TRUE)
Theft[Theft == "False:Secure:FiftyThou"] = sample(BOOL, length(which(Theft == "False:Secure:FiftyThou")), prob = c(0.000002, 0.999998), replace = TRUE)
Theft[Theft == "False:Secure:Million"] = sample(BOOL, length(which(Theft == "False:Secure:Million")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "False:City:FiveThou"] = sample(BOOL, length(which(Theft == "False:City:FiveThou")), prob = c(0.001, 0.999), replace = TRUE)
Theft[Theft == "False:City:TenThou"] = sample(BOOL, length(which(Theft == "False:City:TenThou")), prob = c(0.005, 0.995), replace = TRUE)
Theft[Theft == "False:City:TwentyThou"] = sample(BOOL, length(which(Theft == "False:City:TwentyThou")), prob = c(0.01, 0.99), replace = TRUE)
Theft[Theft == "False:City:FiftyThou"] = sample(BOOL, length(which(Theft == "False:City:FiftyThou")), prob = c(0.01, 0.99), replace = TRUE)
Theft[Theft == "False:City:Million"] = sample(BOOL, length(which(Theft == "False:City:Million")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "False:Suburb:FiveThou"] = sample(BOOL, length(which(Theft == "False:Suburb:FiveThou")), prob = c(0.00001, 0.99999), replace = TRUE)
Theft[Theft == "False:Suburb:TenThou"] = sample(BOOL, length(which(Theft == "False:Suburb:TenThou")), prob = c(0.0002, 0.9998), replace = TRUE)
Theft[Theft == "False:Suburb:TwentyThou"] = sample(BOOL, length(which(Theft == "False:Suburb:TwentyThou")), prob = c(0.0005, 0.9995), replace = TRUE)
Theft[Theft == "False:Suburb:FiftyThou"] = sample(BOOL, length(which(Theft == "False:Suburb:FiftyThou")), prob = c(0.0005, 0.9995), replace = TRUE)
Theft[Theft == "False:Suburb:Million"] = sample(BOOL, length(which(Theft == "False:Suburb:Million")), prob = c(0.000001, 0.999999), replace = TRUE)
Theft[Theft == "False:Rural:FiveThou"] = sample(BOOL, length(which(Theft == "False:Rural:FiveThou")), prob = c(0.00001, 0.99999), replace = TRUE)
Theft[Theft == "False:Rural:TenThou"] = sample(BOOL, length(which(Theft == "False:Rural:TenThou")), prob = c(0.0001, 0.9999), replace = TRUE)
Theft[Theft == "False:Rural:TwentyThou"] = sample(BOOL, length(which(Theft == "False:Rural:TwentyThou")), prob = c(0.0002, 0.9998), replace = TRUE)
Theft[Theft == "False:Rural:FiftyThou"] = sample(BOOL, length(which(Theft == "False:Rural:FiftyThou")), prob = c(0.0002, 0.9998), replace = TRUE)
Theft[Theft == "False:Rural:Million"] = sample(BOOL, length(which(Theft == "False:Rural:Million")), prob = c(0.000001, 0.999999), replace = TRUE)

Accident = apply(cbind(Antilock, Mileage, DrivQuality), 1, paste, collapse = ":")
Accident[Accident == "True:FiveThou:Poor"] = sample(ACC, length(which(Accident == "True:FiveThou:Poor")), prob = c(0.7, 0.2, 0.07, 0.03), replace = TRUE)
Accident[Accident == "True:FiveThou:Normal"] = sample(ACC, length(which(Accident == "True:FiveThou:Normal")), prob = c(0.99, 0.007, 0.002, 0.001), replace = TRUE)
Accident[Accident == "True:FiveThou:Excellent"] = sample(ACC, length(which(Accident == "True:FiveThou:Excellent")), prob = c(0.999, 0.0007, 0.0002, 0.0001), replace = TRUE)
Accident[Accident == "True:TwentyThou:Poor"] = sample(ACC, length(which(Accident == "True:TwentyThou:Poor")), prob = c(0.4, 0.3, 0.2, 0.1), replace = TRUE)
Accident[Accident == "True:TwentyThou:Normal"] = sample(ACC, length(which(Accident == "True:TwentyThou:Normal")), prob = c(0.98, 0.01, 0.005, 0.005), replace = TRUE)
Accident[Accident == "True:TwentyThou:Excellent"] = sample(ACC, length(which(Accident == "True:TwentyThou:Excellent")), prob = c(0.995, 0.003, 0.001, 0.001), replace = TRUE)
Accident[Accident == "True:FiftyThou:Poor"] = sample(ACC, length(which(Accident == "True:FiftyThou:Poor")), prob = c(0.3, 0.3, 0.2, 0.2), replace = TRUE)
Accident[Accident == "True:FiftyThou:Normal"] = sample(ACC, length(which(Accident == "True:FiftyThou:Normal")), prob = c(0.97, 0.02, 0.007, 0.003), replace = TRUE)
Accident[Accident == "True:FiftyThou:Excellent"] = sample(ACC, length(which(Accident == "True:FiftyThou:Excellent")), prob = c(0.99, 0.007, 0.002, 0.001), replace = TRUE)
Accident[Accident == "True:Domino:Poor"] = sample(ACC, length(which(Accident == "True:Domino:Poor")), prob = c(0.2, 0.2, 0.3, 0.3), replace = TRUE)
Accident[Accident == "True:Domino:Normal"] = sample(ACC, length(which(Accident == "True:Domino:Normal")), prob = c(0.95, 0.03, 0.01, 0.01), replace = TRUE)
Accident[Accident == "True:Domino:Excellent"] = sample(ACC, length(which(Accident == "True:Domino:Excellent")), prob = c(0.985, 0.01, 0.003, 0.002), replace = TRUE)
Accident[Accident == "False:FiveThou:Poor"] = sample(ACC, length(which(Accident == "False:FiveThou:Poor")), prob = c(0.6, 0.2, 0.1, 0.1), replace = TRUE)
Accident[Accident == "False:FiveThou:Normal"] = sample(ACC, length(which(Accident == "False:FiveThou:Normal")), prob = c(0.98, 0.01, 0.005, 0.005), replace = TRUE)
Accident[Accident == "False:FiveThou:Excellent"] = sample(ACC, length(which(Accident == "False:FiveThou:Excellent")), prob = c(0.995, 0.003, 0.001, 0.001), replace = TRUE)
Accident[Accident == "False:TwentyThou:Poor"] = sample(ACC, length(which(Accident == "False:TwentyThou:Poor")), prob = c(0.3, 0.2, 0.2, 0.3), replace = TRUE)
Accident[Accident == "False:TwentyThou:Normal"] = sample(ACC, length(which(Accident == "False:TwentyThou:Normal")), prob = c(0.96, 0.02, 0.015, 0.005), replace = TRUE)
Accident[Accident == "False:TwentyThou:Excellent"] = sample(ACC, length(which(Accident == "False:TwentyThou:Excellent")), prob = c(0.99, 0.007, 0.002, 0.001), replace = TRUE)
Accident[Accident == "False:FiftyThou:Poor"] = sample(ACC, length(which(Accident == "False:FiftyThou:Poor")), prob = c(0.2, 0.2, 0.2, 0.4), replace = TRUE)
Accident[Accident == "False:FiftyThou:Normal"] = sample(ACC, length(which(Accident == "False:FiftyThou:Normal")), prob = c(0.95, 0.03, 0.015, 0.005), replace = TRUE)
Accident[Accident == "False:FiftyThou:Excellent"] = sample(ACC, length(which(Accident == "False:FiftyThou:Excellent")), prob = c(0.98, 0.01, 0.005, 0.005), replace = TRUE)
Accident[Accident == "False:Domino:Poor"] = sample(ACC, length(which(Accident == "False:Domino:Poor")), prob = c(0.1, 0.1, 0.3, 0.5), replace = TRUE)
Accident[Accident == "False:Domino:Normal"] = sample(ACC, length(which(Accident == "False:Domino:Normal")), prob = c(0.94, 0.03, 0.02, 0.01), replace = TRUE)
Accident[Accident == "False:Domino:Excellent"] = sample(ACC, length(which(Accident == "False:Domino:Excellent")), prob = c(0.98, 0.01, 0.007, 0.003), replace = TRUE)

Cushioning = apply(cbind(RuggedAuto, Airbag), 1, paste, collapse = ":")
Cushioning[Cushioning == "EggShell:True"] = sample(SKILL3, length(which(Cushioning == "EggShell:True")), prob = c(0.5, 0.3, 0.2, 0), replace = TRUE)
Cushioning[Cushioning == "EggShell:False"] = sample(SKILL3, length(which(Cushioning == "EggShell:False")), prob = c(0.7, 0.3, 0, 0), replace = TRUE)
Cushioning[Cushioning == "Football:True"] = sample(SKILL3, length(which(Cushioning == "Football:True")), prob = c(0, 0.1, 0.6, 0.3), replace = TRUE)
Cushioning[Cushioning == "Football:False"] = sample(SKILL3, length(which(Cushioning == "Football:False")), prob = c(0.1, 0.6, 0.3, 0), replace = TRUE)
Cushioning[Cushioning == "Tank:True"] = sample(SKILL3, length(which(Cushioning == "Tank:True")), prob = c(0, 0, 0, 1), replace = TRUE)
Cushioning[Cushioning == "Tank:False"] = sample(SKILL3, length(which(Cushioning == "Tank:False")), prob = c(0, 0, 0.7, 0.3), replace = TRUE)

ThisCarDam = apply(cbind(Accident, RuggedAuto), 1, paste, collapse = ":")
ThisCarDam[ThisCarDam == "None:EggShell"] = sample(ACC, length(which(ThisCarDam == "None:EggShell")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarDam[ThisCarDam == "None:Football"] = sample(ACC, length(which(ThisCarDam == "None:Football")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarDam[ThisCarDam == "None:Tank"] = sample(ACC, length(which(ThisCarDam == "None:Tank")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarDam[ThisCarDam == "Mild:EggShell"] = sample(ACC, length(which(ThisCarDam == "Mild:EggShell")), prob = c(0.001, 0.9, 0.098, 0.001), replace = TRUE)
ThisCarDam[ThisCarDam == "Mild:Football"] = sample(ACC, length(which(ThisCarDam == "Mild:Football")), prob = c(0.2, 0.75, 0.049999, 0.000001), replace = TRUE)
ThisCarDam[ThisCarDam == "Mild:Tank"] = sample(ACC, length(which(ThisCarDam == "Mild:Tank")), prob = c(0.7, 0.29, 0.009999, 0.000001), replace = TRUE)
ThisCarDam[ThisCarDam == "Moderate:EggShell"] = sample(ACC, length(which(ThisCarDam == "Moderate:EggShell")), prob = c(0.000001, 0.000999, 0.7, 0.299), replace = TRUE)
ThisCarDam[ThisCarDam == "Moderate:Football"] = sample(ACC, length(which(ThisCarDam == "Moderate:Football")), prob = c(0.001, 0.099, 0.8, 0.1), replace = TRUE)
ThisCarDam[ThisCarDam == "Moderate:Tank"] = sample(ACC, length(which(ThisCarDam == "Moderate:Tank")), prob = c(0.05, 0.6, 0.3, 0.05), replace = TRUE)
ThisCarDam[ThisCarDam == "Severe:EggShell"] = sample(ACC, length(which(ThisCarDam == "Severe:EggShell")), prob = c(0.000001, 0.000009, 0.00009, 0.9999), replace = TRUE)
ThisCarDam[ThisCarDam == "Severe:Football"] = sample(ACC, length(which(ThisCarDam == "Severe:Football")), prob = c(0.000001, 0.000999, 0.009, 0.99), replace = TRUE)
ThisCarDam[ThisCarDam == "Severe:Tank"] = sample(ACC, length(which(ThisCarDam == "Severe:Tank")), prob = c(0.05, 0.2, 0.2, 0.55), replace = TRUE)

OtherCarCost = apply(cbind(Accident, RuggedAuto), 1, paste, collapse = ":")
OtherCarCost[OtherCarCost == "None:EggShell"] = sample(VALUE2, length(which(OtherCarCost == "None:EggShell")), prob = c(1, 0, 0, 0), replace = TRUE)
OtherCarCost[OtherCarCost == "None:Football"] = sample(VALUE2, length(which(OtherCarCost == "None:Football")), prob = c(1, 0, 0, 0), replace = TRUE)
OtherCarCost[OtherCarCost == "None:Tank"] = sample(VALUE2, length(which(OtherCarCost == "None:Tank")), prob = c(1, 0, 0, 0), replace = TRUE)
OtherCarCost[OtherCarCost == "Mild:EggShell"] = sample(VALUE2, length(which(OtherCarCost == "Mild:EggShell")), prob = c(0.99, 0.005, 0.00499, 0.00001), replace = TRUE)
OtherCarCost[OtherCarCost == "Mild:Football"] = sample(VALUE2, length(which(OtherCarCost == "Mild:Football")), prob = c(0.98, 0.01, 0.009985, 0.00005), replace = TRUE)
OtherCarCost[OtherCarCost == "Mild:Tank"] = sample(VALUE2, length(which(OtherCarCost == "Mild:Tank")), prob = c(0.95, 0.03, 0.01998, 0.00002), replace = TRUE)
OtherCarCost[OtherCarCost == "Moderate:EggShell"] = sample(VALUE2, length(which(OtherCarCost == "Moderate:EggShell")), prob = c(0.6, 0.2, 0.19998, 0.00002), replace = TRUE)
OtherCarCost[OtherCarCost == "Moderate:Football"] = sample(VALUE2, length(which(OtherCarCost == "Moderate:Football")), prob = c(0.5, 0.2, 0.29997, 0.00003), replace = TRUE)
OtherCarCost[OtherCarCost == "Moderate:Tank"] = sample(VALUE2, length(which(OtherCarCost == "Moderate:Tank")), prob = c(0.4, 0.3, 0.29996, 0.00004), replace = TRUE)
OtherCarCost[OtherCarCost == "Severe:EggShell"] = sample(VALUE2, length(which(OtherCarCost == "Severe:EggShell")), prob = c(0.2, 0.4, 0.39996, 0.00004), replace = TRUE)
OtherCarCost[OtherCarCost == "Severe:Football"] = sample(VALUE2, length(which(OtherCarCost == "Severe:Football")), prob = c(0.1, 0.5, 0.39994, 0.00006), replace = TRUE)
OtherCarCost[OtherCarCost == "Severe:Tank"] = sample(VALUE2, length(which(OtherCarCost == "Severe:Tank")), prob = c(0.005, 0.55, 0.4449, 0.0001), replace = TRUE)

ILiCost = Accident
ILiCost[ILiCost == "None"] = sample(VALUE2, length(which(ILiCost == "None")), prob = c(1, 0, 0, 0), replace = TRUE)
ILiCost[ILiCost == "Mild"] = sample(VALUE2, length(which(ILiCost == "Mild")), prob = c(0.999, 0.000998, 0.000001, 0.000001), replace = TRUE)
ILiCost[ILiCost == "Moderate"] = sample(VALUE2, length(which(ILiCost == "Moderate")), prob = c(0.9, 0.05, 0.03, 0.02), replace = TRUE)
ILiCost[ILiCost == "Severe"] = sample(VALUE2, length(which(ILiCost == "Severe")), prob = c(0.8, 0.1, 0.06, 0.04), replace = TRUE)

MedCost = apply(cbind(Accident, Age, Cushioning), 1, paste, collapse = ":")
MedCost[MedCost == "None:Adolescent:Poor"] = sample(VALUE2, length(which(MedCost == "None:Adolescent:Poor")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Adolescent:Fair"] = sample(VALUE2, length(which(MedCost == "None:Adolescent:Fair")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Adolescent:Good"] = sample(VALUE2, length(which(MedCost == "None:Adolescent:Good")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Adolescent:Excellent"] = sample(VALUE2, length(which(MedCost == "None:Adolescent:Excellent")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Adult:Poor"] = sample(VALUE2, length(which(MedCost == "None:Adult:Poor")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Adult:Fair"] = sample(VALUE2, length(which(MedCost == "None:Adult:Fair")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Adult:Good"] = sample(VALUE2, length(which(MedCost == "None:Adult:Good")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Adult:Excellent"] = sample(VALUE2, length(which(MedCost == "None:Adult:Excellent")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Senior:Poor"] = sample(VALUE2, length(which(MedCost == "None:Senior:Poor")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Senior:Fair"] = sample(VALUE2, length(which(MedCost == "None:Senior:Fair")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Senior:Good"] = sample(VALUE2, length(which(MedCost == "None:Senior:Good")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "None:Senior:Excellent"] = sample(VALUE2, length(which(MedCost == "None:Senior:Excellent")), prob = c(1, 0, 0, 0), replace = TRUE)
MedCost[MedCost == "Mild:Adolescent:Poor"] = sample(VALUE2, length(which(MedCost == "Mild:Adolescent:Poor")), prob = c(0.96, 0.03, 0.009, 0.001), replace = TRUE)
MedCost[MedCost == "Mild:Adolescent:Fair"] = sample(VALUE2, length(which(MedCost == "Mild:Adolescent:Fair")), prob = c(0.98, 0.019, 0.0009, 0.0001), replace = TRUE)
MedCost[MedCost == "Mild:Adolescent:Good"] = sample(VALUE2, length(which(MedCost == "Mild:Adolescent:Good")), prob = c(0.99, 0.0099, 0.00009, 0.00001), replace = TRUE)
MedCost[MedCost == "Mild:Adolescent:Excellent"] = sample(VALUE2, length(which(MedCost == "Mild:Adolescent:Excellent")), prob = c(0.999, 0.00099, 0.000009, 0.000001), replace = TRUE)
MedCost[MedCost == "Mild:Adult:Poor"] = sample(VALUE2, length(which(MedCost == "Mild:Adult:Poor")), prob = c(0.96, 0.03, 0.009, 0.001), replace = TRUE)
MedCost[MedCost == "Mild:Adult:Fair"] = sample(VALUE2, length(which(MedCost == "Mild:Adult:Fair")), prob = c(0.98, 0.019, 0.0009, 0.0001), replace = TRUE)
MedCost[MedCost == "Mild:Adult:Good"] = sample(VALUE2, length(which(MedCost == "Mild:Adult:Good")), prob = c(0.99, 0.0099, 0.00009, 0.00001), replace = TRUE)
MedCost[MedCost == "Mild:Adult:Excellent"] = sample(VALUE2, length(which(MedCost == "Mild:Adult:Excellent")), prob = c(0.999, 0.00099, 0.000009, 0.000001), replace = TRUE)
MedCost[MedCost == "Mild:Senior:Poor"] = sample(VALUE2, length(which(MedCost == "Mild:Senior:Poor")), prob = c(0.9, 0.07, 0.02, 0.01), replace = TRUE)
MedCost[MedCost == "Mild:Senior:Fair"] = sample(VALUE2, length(which(MedCost == "Mild:Senior:Fair")), prob = c(0.95, 0.04, 0.007, 0.003), replace = TRUE)
MedCost[MedCost == "Mild:Senior:Good"] = sample(VALUE2, length(which(MedCost == "Mild:Senior:Good")), prob = c(0.97, 0.025, 0.003, 0.002), replace = TRUE)
MedCost[MedCost == "Mild:Senior:Excellent"] = sample(VALUE2, length(which(MedCost == "Mild:Senior:Excellent")), prob = c(0.99, 0.007, 0.002, 0.001), replace = TRUE)
MedCost[MedCost == "Moderate:Adolescent:Poor"] = sample(VALUE2, length(which(MedCost == "Moderate:Adolescent:Poor")), prob = c(0.5, 0.2, 0.2, 0.1), replace = TRUE)
MedCost[MedCost == "Moderate:Adolescent:Fair"] = sample(VALUE2, length(which(MedCost == "Moderate:Adolescent:Fair")), prob = c(0.8, 0.15, 0.03, 0.02), replace = TRUE)
MedCost[MedCost == "Moderate:Adolescent:Good"] = sample(VALUE2, length(which(MedCost == "Moderate:Adolescent:Good")), prob = c(0.95, 0.02, 0.02, 0.01), replace = TRUE)
MedCost[MedCost == "Moderate:Adolescent:Excellent"] = sample(VALUE2, length(which(MedCost == "Moderate:Adolescent:Excellent")), prob = c(0.99, 0.007, 0.002, 0.001), replace = TRUE)
MedCost[MedCost == "Moderate:Adult:Poor"] = sample(VALUE2, length(which(MedCost == "Moderate:Adult:Poor")), prob = c(0.5, 0.2, 0.2, 0.1), replace = TRUE)
MedCost[MedCost == "Moderate:Adult:Fair"] = sample(VALUE2, length(which(MedCost == "Moderate:Adult:Fair")), prob = c(0.8, 0.15, 0.03, 0.02), replace = TRUE)
MedCost[MedCost == "Moderate:Adult:Good"] = sample(VALUE2, length(which(MedCost == "Moderate:Adult:Good")), prob = c(0.95, 0.02, 0.02, 0.01), replace = TRUE)
MedCost[MedCost == "Moderate:Adult:Excellent"] = sample(VALUE2, length(which(MedCost == "Moderate:Adult:Excellent")), prob = c(0.99, 0.007, 0.002, 0.001), replace = TRUE)
MedCost[MedCost == "Moderate:Senior:Poor"] = sample(VALUE2, length(which(MedCost == "Moderate:Senior:Poor")), prob = c(0.3, 0.3, 0.2, 0.2), replace = TRUE)
MedCost[MedCost == "Moderate:Senior:Fair"] = sample(VALUE2, length(which(MedCost == "Moderate:Senior:Fair")), prob = c(0.5, 0.2, 0.2, 0.1), replace = TRUE)
MedCost[MedCost == "Moderate:Senior:Good"] = sample(VALUE2, length(which(MedCost == "Moderate:Senior:Good")), prob = c(0.9, 0.07, 0.02, 0.01), replace = TRUE)
MedCost[MedCost == "Moderate:Senior:Excellent"] = sample(VALUE2, length(which(MedCost == "Moderate:Senior:Excellent")), prob = c(0.95, 0.03, 0.01, 0.01), replace = TRUE)
MedCost[MedCost == "Severe:Adolescent:Poor"] = sample(VALUE2, length(which(MedCost == "Severe:Adolescent:Poor")), prob = c(0.3, 0.3, 0.2, 0.2), replace = TRUE)
MedCost[MedCost == "Severe:Adolescent:Fair"] = sample(VALUE2, length(which(MedCost == "Severe:Adolescent:Fair")), prob = c(0.5, 0.2, 0.2, 0.1), replace = TRUE)
MedCost[MedCost == "Severe:Adolescent:Good"] = sample(VALUE2, length(which(MedCost == "Severe:Adolescent:Good")), prob = c(0.9, 0.07, 0.02, 0.01), replace = TRUE)
MedCost[MedCost == "Severe:Adolescent:Excellent"] = sample(VALUE2, length(which(MedCost == "Severe:Adolescent:Excellent")), prob = c(0.95, 0.03, 0.01, 0.01), replace = TRUE)
MedCost[MedCost == "Severe:Adult:Poor"] = sample(VALUE2, length(which(MedCost == "Severe:Adult:Poor")), prob = c(0.3, 0.3, 0.2, 0.2), replace = TRUE)
MedCost[MedCost == "Severe:Adult:Fair"] = sample(VALUE2, length(which(MedCost == "Severe:Adult:Fair")), prob = c(0.5, 0.2, 0.2, 0.1), replace = TRUE)
MedCost[MedCost == "Severe:Adult:Good"] = sample(VALUE2, length(which(MedCost == "Severe:Adult:Good")), prob = c(0.9, 0.07, 0.02, 0.01), replace = TRUE)
MedCost[MedCost == "Severe:Adult:Excellent"] = sample(VALUE2, length(which(MedCost == "Severe:Adult:Excellent")), prob = c(0.95, 0.03, 0.01, 0.01), replace = TRUE)
MedCost[MedCost == "Severe:Senior:Poor"] = sample(VALUE2, length(which(MedCost == "Severe:Senior:Poor")), prob = c(0.2, 0.2, 0.3, 0.3), replace = TRUE)
MedCost[MedCost == "Severe:Senior:Fair"] = sample(VALUE2, length(which(MedCost == "Severe:Senior:Fair")), prob = c(0.3, 0.3, 0.2, 0.2), replace = TRUE)
MedCost[MedCost == "Severe:Senior:Good"] = sample(VALUE2, length(which(MedCost == "Severe:Senior:Good")), prob = c(0.6, 0.3, 0.07, 0.03), replace = TRUE)
MedCost[MedCost == "Severe:Senior:Excellent"] = sample(VALUE2, length(which(MedCost == "Severe:Senior:Excellent")), prob = c(0.9, 0.05, 0.03, 0.02), replace = TRUE)

ThisCarCost = apply(cbind(ThisCarDam, CarValue, Theft), 1, paste, collapse = ":")
ThisCarCost[ThisCarCost == "None:FiveThou:True"] = sample(VALUE2, length(which(ThisCarCost == "None:FiveThou:True")), prob = c(0.2, 0.8, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:FiveThou:False"] = sample(VALUE2, length(which(ThisCarCost == "None:FiveThou:False")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:TenThou:True"] = sample(VALUE2, length(which(ThisCarCost == "None:TenThou:True")), prob = c(0.05, 0.95, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:TenThou:False"] = sample(VALUE2, length(which(ThisCarCost == "None:TenThou:False")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:TwentyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "None:TwentyThou:True")), prob = c(0.04, 0.01, 0.95, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:TwentyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "None:TwentyThou:False")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:FiftyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "None:FiftyThou:True")), prob = c(0.04, 0.01, 0.95, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:FiftyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "None:FiftyThou:False")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "None:Million:True"] = sample(VALUE2, length(which(ThisCarCost == "None:Million:True")), prob = c(0.04, 0.01, 0.2, 0.75), replace = TRUE)
ThisCarCost[ThisCarCost == "None:Million:False"] = sample(VALUE2, length(which(ThisCarCost == "None:Million:False")), prob = c(1, 0, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:FiveThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Mild:FiveThou:True")), prob = c(0.15, 0.85, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:FiveThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Mild:FiveThou:False")), prob = c(0.95, 0.05, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:TenThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Mild:TenThou:True")), prob = c(0.03, 0.97, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:TenThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Mild:TenThou:False")), prob = c(0.95, 0.05, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:TwentyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Mild:TwentyThou:True")), prob = c(0.03, 0.02, 0.95, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:TwentyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Mild:TwentyThou:False")), prob = c(0.99, 0.01, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:FiftyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Mild:FiftyThou:True")), prob = c(0.03, 0.02, 0.95, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:FiftyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Mild:FiftyThou:False")), prob = c(0.99, 0.01, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:Million:True"] = sample(VALUE2, length(which(ThisCarCost == "Mild:Million:True")), prob = c(0.02, 0.03, 0.25, 0.7), replace = TRUE)
ThisCarCost[ThisCarCost == "Mild:Million:False"] = sample(VALUE2, length(which(ThisCarCost == "Mild:Million:False")), prob = c(0.98, 0.01, 0.01, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:FiveThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:FiveThou:True")), prob = c(0.05, 0.95, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:FiveThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:FiveThou:False")), prob = c(0.25, 0.75, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:TenThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:TenThou:True")), prob = c(0.01, 0.99, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:TenThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:TenThou:False")), prob = c(0.15, 0.85, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:TwentyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:TwentyThou:True")), prob = c(0.001, 0.001, 0.998, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:TwentyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:TwentyThou:False")), prob = c(0.01, 0.01, 0.98, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:FiftyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:FiftyThou:True")), prob = c(0.001, 0.001, 0.998, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:FiftyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:FiftyThou:False")), prob = c(0.005, 0.005, 0.99, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:Million:True"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:Million:True")), prob = c(0.001, 0.001, 0.018, 0.98), replace = TRUE)
ThisCarCost[ThisCarCost == "Moderate:Million:False"] = sample(VALUE2, length(which(ThisCarCost == "Moderate:Million:False")), prob = c(0.003, 0.003, 0.044, 0.95), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:FiveThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Severe:FiveThou:True")), prob = c(0.03, 0.97, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:FiveThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Severe:FiveThou:False")), prob = c(0.05, 0.95, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:TenThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Severe:TenThou:True")), prob = c(0.000001, 0.999999, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:TenThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Severe:TenThou:False")), prob = c(0.01, 0.99, 0, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:TwentyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Severe:TwentyThou:True")), prob = c(0.000001, 0.000001, 0.999998, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:TwentyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Severe:TwentyThou:False")), prob = c(0.005, 0.005, 0.99, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:FiftyThou:True"] = sample(VALUE2, length(which(ThisCarCost == "Severe:FiftyThou:True")), prob = c(0.000001, 0.000001, 0.999998, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:FiftyThou:False"] = sample(VALUE2, length(which(ThisCarCost == "Severe:FiftyThou:False")), prob = c(0.001, 0.001, 0.998, 0), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:Million:True"] = sample(VALUE2, length(which(ThisCarCost == "Severe:Million:True")), prob = c(0.000001, 0.000001, 0.009998, 0.99), replace = TRUE)
ThisCarCost[ThisCarCost == "Severe:Million:False"] = sample(VALUE2, length(which(ThisCarCost == "Severe:Million:False")), prob = c(0.000001, 0.000001, 0.029998, 0.97), replace = TRUE)

PropCost = apply(cbind(OtherCarCost, ThisCarCost), 1, paste, collapse = ":")
PropCost[PropCost == "Thousand:Thousand"] = sample(VALUE2, length(which(PropCost == "Thousand:Thousand")), prob = c(0.7, 0.3, 0, 0), replace = TRUE)
PropCost[PropCost == "Thousand:TenThou"] = sample(VALUE2, length(which(PropCost == "Thousand:TenThou")), prob = c(0, 0.95, 0.05, 0), replace = TRUE)
PropCost[PropCost == "Thousand:HundredThou"] = sample(VALUE2, length(which(PropCost == "Thousand:HundredThou")), prob = c(0, 0, 0.98, 0.02), replace = TRUE)
PropCost[PropCost == "Thousand:Million"] = sample(VALUE2, length(which(PropCost == "Thousand:Million")), prob = c(0, 0, 0, 1), replace = TRUE)
PropCost[PropCost == "TenThou:Thousand"] = sample(VALUE2, length(which(PropCost == "TenThou:Thousand")), prob = c(0, 0.95, 0.05, 0), replace = TRUE)
PropCost[PropCost == "TenThou:TenThou"] = sample(VALUE2, length(which(PropCost == "TenThou:TenThou")), prob = c(0, 0.6, 0.4, 0), replace = TRUE)
PropCost[PropCost == "TenThou:HundredThou"] = sample(VALUE2, length(which(PropCost == "TenThou:HundredThou")), prob = c(0, 0, 0.95, 0.05), replace = TRUE)
PropCost[PropCost == "TenThou:Million"] = sample(VALUE2, length(which(PropCost == "TenThou:Million")), prob = c(0, 0, 0, 1), replace = TRUE)
PropCost[PropCost == "HundredThou:Thousand"] = sample(VALUE2, length(which(PropCost == "HundredThou:Thousand")), prob = c(0, 0, 0.98, 0.02), replace = TRUE)
PropCost[PropCost == "HundredThou:TenThou"] = sample(VALUE2, length(which(PropCost == "HundredThou:TenThou")), prob = c(0, 0, 0.8, 0.2), replace = TRUE)
PropCost[PropCost == "HundredThou:HundredThou"] = sample(VALUE2, length(which(PropCost == "HundredThou:HundredThou")), prob = c(0, 0, 0.6, 0.4), replace = TRUE)
PropCost[PropCost == "HundredThou:Million"] = sample(VALUE2, length(which(PropCost == "HundredThou:Million")), prob = c(0, 0, 0, 1), replace = TRUE)
PropCost[PropCost == "Million:Thousand"] = sample(VALUE2, length(which(PropCost == "Million:Thousand")), prob = c(0, 0, 0, 1), replace = TRUE)
PropCost[PropCost == "Million:TenThou"] = sample(VALUE2, length(which(PropCost == "Million:TenThou")), prob = c(0, 0, 0, 1), replace = TRUE)
PropCost[PropCost == "Million:HundredThou"] = sample(VALUE2, length(which(PropCost == "Million:HundredThou")), prob = c(0, 0, 0, 1), replace = TRUE)
PropCost[PropCost == "Million:Million"] = sample(VALUE2, length(which(PropCost == "Million:Million")), prob = c(0, 0, 0, 1), replace = TRUE)

insurance = data.frame(
  GoodStudent = factor(GoodStudent, levels = BOOL), 
  Age = factor(Age, levels = AGE),
  SocioEcon = factor(SocioEcon, levels = SEC),
  RiskAversion = factor(RiskAversion, levels = RISK),
  VehicleYear = factor(VehicleYear, levels = YEAR),
  ThisCarDam = factor(ThisCarDam, levels = ACC),
  RuggedAuto = factor(RuggedAuto, levels = RUGGED),
  Accident = factor(Accident, levels = ACC),
  MakeModel = factor(MakeModel, levels = MODEL),
  DrivQuality = factor(DrivQuality, levels = SKILL2),
  Mileage = factor(Mileage, levels = MIL),
  Antilock = factor(Antilock, levels = BOOL),
  DrivingSkill = factor(DrivingSkill, levels = SKILL),
  SeniorTrain = factor(SeniorTrain, levels = BOOL),
  ThisCarCost = factor(ThisCarCost, levels = VALUE2),
  Theft = factor(Theft, levels = BOOL),
  CarValue = factor(CarValue, levels = VALUE),
  HomeBase = factor(HomeBase, levels = HOME),
  AntiTheft = factor(AntiTheft, levels = BOOL),
  PropCost = factor(PropCost, levels = VALUE2),
  OtherCarCost = factor(OtherCarCost, levels = VALUE2),
  OtherCar = factor(OtherCar, levels = BOOL),
  MedCost = factor(MedCost, levels = VALUE2),
  Cushioning = factor(Cushioning, levels = SKILL3),
  Airbag = factor(Airbag, levels = BOOL),
  ILiCost = factor(ILiCost, levels = VALUE2),
  DrivHist = factor(DrivHist, levels = HIST)
)
