% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ume.network.R
\name{ume.network.data}
\alias{ume.network.data}
\title{Make a network object for the unrelated mean effects model (inconsistency model) containing data, priors, and a JAGS model file}
\usage{
ume.network.data(
  Outcomes,
  Study,
  Treat,
  N = NULL,
  SE = NULL,
  response = NULL,
  type = "random",
  mean.mu = NULL,
  prec.mu = NULL,
  mean.d = NULL,
  prec.d = NULL,
  hy.prior = list("dunif", 0, 5),
  dic = TRUE
)
}
\arguments{
\item{Outcomes}{Arm-level outcomes. If it is a multinomial response, the matrix would be arms (row) by multinomial categories (column). If it is binomial or normal, it would be a vector.}

\item{Study}{A vector of study indicator for each arm}

\item{Treat}{A vector of treatment indicator for each arm. Treatments should have positive integer values starting from 1 to total number of treatments. In a study, lowest number is taken as the baseline treatment.}

\item{N}{A vector of total number of observations in each arm. Used for binomial and multinomial responses.}

\item{SE}{A vector of standard error for each arm. Used only for normal response.}

\item{response}{Specification of the outcomes type. Must specify one of the following: "normal", "binomial", or "multinomial".}

\item{type}{Type of model fitted: either "random" for random effects model or "fixed" for fixed effects model. Default is "random".}

\item{mean.mu}{Prior mean for the study effect (baseline risk)}

\item{prec.mu}{Prior precision for the study effect (baseline risk)}

\item{mean.d}{Prior mean for the relative effect}

\item{prec.d}{Prior precision for the relative effect}

\item{hy.prior}{Prior for the heterogeneity parameter. Supports uniform, gamma, and half normal for normal. It should be a list of length 3, where first element should be the distribution (one of dunif, dgamma, dhnorm, dwish) and the next two are the parameters associated with the distribution. For example, list("dunif", 0, 5) give uniform prior with lower bound 0 and upper bound 5 for the heterogeneity parameter.}

\item{dic}{This is an indicator for whether user wants to calculate DIC. Model stores less information if you set it to FALSE.}
}
\value{
Creates list of variables that are used to run the model using \code{\link{ume.network.run}}
}
\description{
This is similar to the function \code{\link{network.data}}, except this is used for the unrelated mean effects model.
}
\examples{
network <- with(thrombolytic, {
 ume.network.data(Outcomes, Study, Treat, N = N, response = "binomial")
})
network
}
\references{
S. Dias, N.J. Welton, A.J. Sutton, D.M. Caldwell, G. Lu, and A.E. Ades (2013), \emph{Evidence synthesis for decision making 4: inconsistency in networks of evidence based on randomized controlled trials}, Medical Decision Making 33(5):641-656. [\url{https://doi.org/10.1177/0272989X12455847}]
}
