% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coanc.R
\name{coanc}
\alias{coanc}
\title{Construct the coancestry matrix of an admixture model}
\usage{
coanc(Q, F)
}
\arguments{
\item{Q}{The \eqn{n \times k}{n-by-k} admixture proportion matrix}

\item{F}{Either the \eqn{k \times k}{k-by-k} intermediate subpopulation coancestry matrix (for the complete admixture model), or the length-\eqn{k} vector of intermediate subpopulation \eqn{F_{ST}}{FST} values (for the BN-PSD model), or a scalar \eqn{F_{ST}}{FST} value shared by all intermediate subpopulations.}
}
\value{
The \eqn{n \times n}{n-by-n} coancestry matrix \eqn{\Theta}
}
\description{
In the most general case, the \eqn{n \times n}{n-by-n} coancestry matrix \eqn{\Theta} of admixed individuals is determined by the \eqn{n \times k}{n-by-k} admixture proportion matrix \eqn{Q} and the \eqn{k \times k}{k-by-k} intermediate subpopulation coancestry matrix \eqn{\Psi}, given by
\deqn{\Theta = Q \Psi Q^T}{\Theta = Q * \Psi * Q^T}
In the BN-PSD model \eqn{\Psi} is a diagonal matrix (with \eqn{F_{ST}}{FST} values for the intermediate subpopulations along the diagonal, zero values off-diagonal).
}
\examples{
# a trivial case: unadmixed individuals from independent subpopulations
n <- 5 # number of individuals/subpops
Q <- diag(rep.int(1, n)) # unadmixed individuals
F <- 0.2 # equal Fst for all subpops
Theta <- coanc(Q, F) # diagonal coancestry matryx

# a more complicated admixture model
n <- 5 # number of individuals
k <- 2 # number of intermediate subpops
sigma <- 1 # dispersion parameter of intermediate subpops
Q <- q1d(n, k, sigma) # non-trivial admixture proportions
F <- c(0.1, 0.3) # different Fst for each of the k subpops
Theta <- coanc(Q, F) # non-trivial coancestry matrix

}
