% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bold_seq}
\alias{bold_seq}
\title{Search BOLD for sequences.}
\usage{
bold_seq(taxon = NULL, ids = NULL, bin = NULL, container = NULL,
  institutions = NULL, researchers = NULL, geo = NULL, marker = NULL,
  response = FALSE, callopts = list())
}
\arguments{
\item{taxon}{(character) Returns all records containing matching taxa. Taxa includes the ranks of
phylum, class, order, family, subfamily, genus, and species.}

\item{ids}{(character) Returns all records containing matching IDs. IDs include Sample IDs,
Process IDs, Museum IDs and Field IDs.}

\item{bin}{(character) Returns all records contained in matching BINs. A BIN is defined by a
Barcode Index Number URI.}

\item{container}{(character) Returns all records contained in matching projects or datasets.
Containers include project codes and dataset codes}

\item{institutions}{(character) Returns all records stored in matching institutions. Institutions
are the Specimen Storing Site.}

\item{researchers}{(character) Returns all records containing matching researcher names.
Researchers include collectors and specimen identifiers.}

\item{geo}{(character) Returns all records collected in matching geographic sites. Geographic
sites includes countries and province/states.}

\item{response}{(logical) Note that response is the object that returns from the Curl call,
useful for debugging, and getting detailed info on the API call.}

\item{callopts}{(character) curl debugging opts passed on to httr::GET}

\item{marker}{(character) Returns all records containing matching marker codes.}
}
\value{
A list with each element of length 4 with slots for id, name, gene, and sequence.
}
\description{
Get sequences for a taxonomic name, id, bin, container, institution, researcher, geographic
place, or gene.
}
\examples{
\dontrun{
bold_seq(taxon='Coelioxys')
bold_seq(taxon='Aglae')
bold_seq(taxon=c('Coelioxys','Osmia'))
bold_seq(ids='ACRJP618-11')
bold_seq(ids=c('ACRJP618-11','ACRJP619-11'))
bold_seq(bin='BOLD:AAA5125')
bold_seq(container='ACRJP')
bold_seq(institutions='Biodiversity Institute of Ontario')
bold_seq(researchers='Thibaud Decaens')
bold_seq(geo='Ireland')
bold_seq(geo=c('Ireland','Denmark'))

# Return the httr response object for detailed Curl call response details
res <- bold_seq(taxon='Coelioxys', response=TRUE)
res$url
res$status_code
res$headers
}
\donttest{
bold_seq(marker='COI-5P')
bold_seq(marker=c('rbcL','matK'))
}
}

