% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fence_theorems}
\alias{fence_theorems}
\title{Convert the syntax of theorem and proof environments from code blocks to
fenced Divs}
\usage{
fence_theorems(input, text = xfun::read_utf8(input), output = NULL)
}
\arguments{
\item{input}{Path to an Rmd file that contains theorem environments written
in the syntax of code blocks.}

\item{text}{A character vector of the Rmd source. When \code{text} is
provided, the \code{input} argument will be ignored.}

\item{output}{The output file to write the converted input content. You can
specify \code{output} to be identical to \code{input}, which means the
input file will be overwritten. If you want to overwrite the input file,
you are strongly recommended to put the file under version control or make
a backup copy in advance.}
}
\value{
If \code{output = NULL}, the converted text is returned, otherwise
  the text is written to the output file.
}
\description{
This function converts the syntax \samp{```{theorem, label, ...}} to
\samp{::: {.theorem #label ...}} (Pandoc's fenced Div) for theorem
environments.
}
\references{
Learn more about
  \href{https://bookdown.org/yihui/bookdown/markdown-extensions-by-bookdown.html#theorems}{theorems
   and proofs} and
  \href{https://bookdown.org/yihui/rmarkdown-cookbook/custom-blocks.html}{custom
   blocks} in the \pkg{bookdown} book.
}
