% Generated by roxygen2 (4.0.1): do not edit by hand
\name{boolboot}
\alias{boolboot}
\title{Bootstrap for Boolean Models}
\usage{
boolboot(obj, n = 100, method = "nlminb", cluster = NULL, ...)
}
\arguments{
\item{obj}{boolean model object as produced by \code{\link{boolprep}} and
first estimated with \code{\link{boolean}}.}

\item{n}{integer specifying the number of bootstrap estimates. Defaults to
\code{100}.}

\item{method}{string specifying the method of estimation. The specified
method should be one of those available from the \code{\link{optimx}} or
\code{\link{optim}} functions. Defaults to \code{"nlminb"}.}

\item{cluster}{string vector specifying hosts to use for parallel processing
through \code{parallel} (see \code{\link{makeCluster}}). Defaults to \code{NULL}
indicating no clustering.}

\item{...}{additional parameters to pass on to subsequent functions.}
}
\value{
\code{boolboot} returns a \code{boolboot} model object. This
object is identical to a boolean model object but with an additional
\code{model.boot} slot containing the results of the bootstrap. A separate
object type is used to help prevent the accidential loss of bootstrap
estimates.
}
\description{
Performs bootstrap estimates of a boolean model.
}
\details{
\code{boolboot} performs bootstrap estimated of a boolean model specified
by \code{\link{boolprep}} and first estimated with \code{\link{boolean}}.
}
\author{
Jason W. Morgan (\email{morgan.746@osu.edu})
}
\references{
Braumoeller, Bear F. (2003) ``Causal Complexity and the Study
of Politics.'' \emph{Political Analysis} 11(3): 209--233.
}
\seealso{
See \code{\link{boolprep}} for model setup, \code{\link{boolean}}
for estimation, the \code{parallel} package for details on clustering,
and \code{\link{optimx}} and \code{\link{optim}} for estimation methods.
}

