% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambert_w_function.R
\name{lambert_w_function}
\alias{lambert_w_function}
\alias{lambert_w0}
\alias{lambert_wm1}
\alias{lambert_w0_prime}
\alias{lambert_wm1_prime}
\title{Lambert W Function and Its Derivatives}
\usage{
lambert_w0(z)

lambert_wm1(z)

lambert_w0_prime(z)

lambert_wm1_prime(z)
}
\arguments{
\item{z}{Argument of the Lambert W function}
}
\value{
A single numeric value with the computed Lambert W function or its derivative.
}
\description{
Functions to compute the Lambert W function and its derivatives for the principal branch (\eqn{W_0}) and the branch -1 (\eqn{W_{-1}}).
}
\examples{
# Lambert W Function (Principal Branch)
lambert_w0(0.3)
# Lambert W Function (Branch -1)
lambert_wm1(-0.3)
# Derivative of the Lambert W Function (Principal Branch)
lambert_w0_prime(0.3)
# Derivative of the Lambert W Function (Branch -1)
lambert_wm1_prime(-0.3)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/lambert_w.html}{Boost Documentation}
for more details on the mathematical background.
}
