% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_statistics.R
\name{univariate_statistics}
\alias{univariate_statistics}
\alias{mean_boost}
\alias{variance.default}
\alias{sample_variance}
\alias{mean_and_sample_variance}
\alias{skewness.default}
\alias{kurtosis.default}
\alias{excess_kurtosis}
\alias{first_four_moments}
\alias{median_boost}
\alias{median_absolute_deviation}
\alias{interquartile_range}
\alias{gini_coefficient}
\alias{sample_gini_coefficient}
\alias{mode.default}
\title{Univariate Statistics Functions}
\usage{
mean_boost(x)

\method{variance}{default}(x, ...)

sample_variance(x)

mean_and_sample_variance(x)

\method{skewness}{default}(x, ...)

\method{kurtosis}{default}(x, ...)

excess_kurtosis(x)

first_four_moments(x)

median_boost(x)

median_absolute_deviation(x)

interquartile_range(x)

gini_coefficient(x)

sample_gini_coefficient(x)

\method{mode}{default}(x, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{...}{Additional arguments (not used).}
}
\value{
A numeric value or vector with the computed statistic.
}
\description{
Functions to compute various univariate statistics.
}
\examples{
# Mean
mean_boost(c(1, 2, 3, 4, 5))
# Variance
variance(c(1, 2, 3, 4, 5))
# Sample Variance
sample_variance(c(1, 2, 3, 4, 5))
# Mean and Sample Variance
mean_and_sample_variance(c(1, 2, 3, 4, 5))
# Skewness
skewness(c(1, 2, 3, 4, 5))
# Kurtosis
kurtosis(c(1, 2, 3, 4, 5))
# Excess Kurtosis
excess_kurtosis(c(1, 2, 3, 4, 5))
# First Four Moments
first_four_moments(c(1, 2, 3, 4, 5))
# Median
median_boost(c(1, 2, 3, 4, 5))
# Median Absolute Deviation
median_absolute_deviation(c(1, 2, 3, 4, 5))
# Interquartile Range
interquartile_range(c(1, 2, 3, 4, 5))
# Gini Coefficient
gini_coefficient(c(1, 2, 3, 4, 5))
# Sample Gini Coefficient
sample_gini_coefficient(c(1, 2, 3, 4, 5))
# Mode
mode(c(1, 2, 2, 3, 4))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/univariate_statistics.html}{Boost Documentation} for more details on the mathematical background.
}
