% Generated by roxygen2 (4.0.0): do not edit by hand
\name{arcfsAggregator}
\alias{arcfsAggregator}
\title{Aggregator for the arc-fs algorithm.}
\usage{
arcfsAggregator(estimators, beta, ..., .parallelPredict = FALSE,
  .parallelTally = FALSE, .rngSeed = 1234)
}
\arguments{
\item{estimators}{a list of estimators which must produce output in the same
response-space. This is usually the output of some reweighter function.}

\item{...}{this does nothing -- meant to swallow auxillary output from
reweighter function.}

\item{.parallelPredict}{a boolean indicating if prediction should be carried
out in parallel.}

\item{beta}{a vector of scalar weights associated to each estimator in
\code{estimators}}

\item{.parallelTally}{a boolean indicating if vote tallying should be
performed in parallel. Unless you have more than 1,000 votes / observation,
you probably won't see much performance gain by parallelizing this step.}

\item{.rngSeed}{the RNG seed sent to
\code{\link{predictClassFromWeightedVote}} in the case of a tie.}
}
\value{
a function whose sole argument is \code{newdata} and whose output
is the aggregated predictions of the boosted ensemble, \code{estimators}.

For internal bookkeeping, this function is inherits from the
'\code{aggregator}' class.
}
\description{
A (parallelized) implementation of the aggregator described in
the arc-fs algorithm.
}
\details{
By default, this function will perform its predictions in sequence
across the estimators in \code{estimators}. To predict in parallel, change
\code{.parallelPredict} to \code{TRUE}.
}
\note{
In accord with the arc-fs algorithm, there is the assumption that the
estimators in \code{estimators} are classifiers. More aptly, their output is
either of factor or character-type.
}
\seealso{
Other aggregators: \code{\link{adaboostAggregator}};
  \code{\link{arcx4Aggregator}},
  \code{\link{vanillaAggregator}},
  \code{\link{weightedAggregator}}; \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}}

Other arc-fs: \code{\link{arcfsReweighter}}
}

