% Generated by roxygen2 (4.0.0): do not edit by hand
\name{arcx4Aggregator}
\alias{arcx4Aggregator}
\alias{vanillaAggregator}
\alias{weightedAggregator}
\title{Stock aggregators}
\usage{
arcx4Aggregator(estimators, ..., .parallelPredict = FALSE,
  .parallelTally = FALSE, .rngSeed = 1234)

vanillaAggregator(estimators, ..., .parallelPredict = FALSE,
  .parallelTally = FALSE, .rngSeed = 1234)

weightedAggregator(estimators, weights, ..., .parallelPredict = FALSE,
  .parallelTally = FALSE, .rngSeed = 1234)
}
\arguments{
\item{weights}{a vector of scalar weights associated to each estimator in
\code{estimators}}

\item{estimators}{a list of estimators which must produce output in the same
response-space. This is usually the output of some reweighter function.}

\item{...}{this does nothing -- meant to swallow auxillary output from
reweighter function.}

\item{.parallelPredict}{a boolean indicating if prediction should be carried
out in parallel.}

\item{.parallelTally}{a boolean indicating if vote tallying should be
performed in parallel. Unless you have more than 1,000 votes / observation,
you probably won't see much performance gain by parallelizing this step.}

\item{.rngSeed}{the RNG seed sent to \code{\link{predictClassFromVote}} or
\code{\link{predictClassFromWeightedVote}}.
in the case of a tie.}
}
\value{
a function whose sole argument is \code{newdata} and whose output
is the aggregated predictions of the boosted ensemble, \code{estimators}.

For internal bookkeeping, this function is inherits from the
'\code{aggregator}' class.
}
\description{
Parallelized implementations of weighted and unweighted "classification by
voting" procedures.
}
\details{
\code{arcx4Aggregator} is just \code{vanillaAggregator} by another name.

If performing regression and your estimators produce \code{NA}'s, you
can have \code{\link{weighted.mean}} remove the \code{NA}'s by passing
\code{na.rm=TRUE} to \code{weightedAggregator}'s function call.
}
\note{
It's assumed that the estimators in \code{estimators} are classifiers.
More aptly, their output is either of factor or character-type.
}
\seealso{
\code{\link{predictClassFromWeightedVote}}; \code{\link{predictClassFromVote}}

Other aggregators: \code{\link{adaboostAggregator}};
  \code{\link{arcfsAggregator}}; \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}}
}

