% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDistributionsToCIs.R
\name{getGammaFromCI}
\alias{getGammaFromCI}
\title{Find the best-fit gamma distribution for a given confidence interval.}
\usage{
getGammaFromCI(qLow, qUpp, alpha = 0.05, initPars = c(1, 1), maxiter = 1000)
}
\arguments{
\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A vector of length 2 giving the initial parameter values (shape & rate) to start the optimisation; defaults to c(1,1).}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A list with 5 elements:
\item{r}{The sampling function.}
\item{d}{The density function.}
\item{p}{The distribution function.}
\item{q}{The quantile function.}
\item{pars}{A vector of length 2 giving the shape and rate for the best-fit gamma distribution (\code{shape} and \code{rate} as in \code{\link{rgamma}}, \code{\link{dgamma}}, \code{\link{pgamma}}, \code{\link{qgamma}}).}
}
\description{
Finds the best-fit gamma distribution for a given confidence interval; returns the corresponding density, distribution, quantile and sampling functions.
}
\examples{
n<-getGammaFromCI(qLow=0.82,qUpp=5.14)
print(n$pars) # the fitted parameter values (shape & rate)
n$r(10) # 10 random values from the fitted gamma distribution
n$d(6) # the probability density at x=6 for the gamma distribution
n$p(2) # the cumulative density at x=2 for the fitted gamma distribution
n$q(c(0.25,0.5,0.75)) # the 25th, 50th (median) and 75th percentiles of the fitted distribution
x<-seq(0,8,length=1e3)
y<-n$d(x)
plot(x,y,type="l",xlab="",ylab="density") # density plot for the fitted gamma distribution

}
\seealso{
\code{\link{identifyGammaPars}}, \code{\link{optim}}, \code{\link{dgamma}}
}
