% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgpls_bootYT.R
\name{permcoefs.sgpls.CSim}
\alias{permcoefs.sgpls.CSim}
\title{Permutation Bootstrap (Y,T) function for plsRglm}
\usage{
permcoefs.sgpls.CSim(
  dataRepYtt,
  ind,
  nt,
  modele,
  family = binomial,
  maxcoefvalues,
  ifbootfail
)
}
\arguments{
\item{dataRepYtt}{Dataset with tt components to resample}

\item{ind}{indices for resampling}

\item{nt}{number of components to use}

\item{modele}{type of modele to use, see \link{plsRglm}. Not used, 
please specify the family instead.}

\item{family}{glm family to use, see \link{plsRglm}}

\item{maxcoefvalues}{maximum values allowed for the estimates of the
coefficients to discard those coming from singular bootstrap samples}

\item{ifbootfail}{value to return if the estimation fails on a bootstrap
sample}
}
\value{
Numeric vector of the components computed using a bootstrap 
resampling or \code{ifbootfail} value if the
bootstrap computation fails.
}
\description{
Permutation Bootstrap (Y,T) function for plsRglm
}
\examples{
set.seed(4619)
xran=cbind(rbinom(30,1,.2),matrix(rnorm(150),30,5))
permcoefs.sgpls.CSim(xran, ind=sample(1:nrow(xran)), maxcoefvalues=1e5, 
ifbootfail=rep(NA,3))

}
\references{
A new bootstrap-based stopping criterion in PLS component construction,
J. Magnanensi, M. Maumy-Bertrand, N. Meyer and F. Bertrand (2016), in The Multiple Facets of Partial Least Squares and Related Methods, 
\doi{10.1007/978-3-319-40643-5_18}\cr

A new universal resample-stable bootstrap-based stopping criterion for PLS component construction,
J. Magnanensi, F. Bertrand, M. Maumy-Bertrand and N. Meyer, (2017), Statistics and Compututing, 27, 757–774. 
\doi{10.1007/s11222-016-9651-4}\cr

New developments in Sparse PLS regression, J. Magnanensi, M. Maumy-Bertrand, 
N. Meyer and F. Bertrand, (2021), Frontiers in Applied Mathematics and Statistics, 
accepted.
}
\author{
Jérémy Magnanensi, Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
