% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moc_analysis.R
\name{analyze_moc_datasets}
\alias{analyze_moc_datasets}
\title{Multi-Method Ensemble Clustering Analysis for Multiple-Objective Clustering (MOC) Datasets}
\usage{
analyze_moc_datasets(
  datasets,
  selected,
  n_ref = 3,
  B = 100,
  plot = TRUE,
  plot_file = NULL
)
}
\arguments{
\item{datasets}{List of datasets to analyze}

\item{selected}{Indices of datasets to analyze}

\item{n_ref}{Number of reference distributions (default: 3)}

\item{B}{Number of bootstrap samples (default: 100)}

\item{plot}{Whether to generate plots (default: TRUE)}

\item{plot_file}{Output file for plots (default: NULL)}
}
\value{
A list containing:
\describe{
  \item{results}{Results for each dataset}
  \item{ari_table}{Adjusted Rand Index comparison table}
  \item{runtime_table}{Runtime comparison table}
  \item{plots}{List of generated plots if plot=TRUE}
}
}
\description{
Performs ensemble clustering analysis on multiple datasets using
different clustering methods and compares their performance.
}
