% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_funcs.R
\name{analyze_game}
\alias{analyze_game}
\title{Analyze Game Results and Determine Winner}
\usage{
analyze_game(plyr_vv, comp_vv, mode = "t", conf.level = 0.95, ...)
}
\arguments{
\item{plyr_vv}{A numeric vector storing the values of the cards dealt to the
player.}

\item{comp_vv}{A numeric vector storing the values of the cards dealt to the
computer.}

\item{mode}{A character string indicating the type of test. Valid options are
"t" for independent t-test
and "pt" for paired t-test. Default is "t".}

\item{conf.level}{A confidence level for \code{npboottprm::nonparboot},
\code{stats::t.test}. The confidence level is also used to set the alpha
level to alpha = 1 - conf.level}

\item{...}{Additional arguments passed to the \code{npboottprm::nonparboot}
function.}
}
\value{
A list containing:
\itemize{
\item \code{bootstrap_results}: A list containing results from the bootstrap test.
\item \code{classical_results}: A list containing results from the classical t-test.
\item \code{winner}: A character string indicating the winner ("Player Wins", "Computer Wins", or "Draw").
}
}
\description{
This function analyzes the results of the game using both nonparametric
bootstrap with pooled resampling and classical t-tests. It then determines
the winner based on the bootstrap results and effect size.
}
\examples{
# Analyze a sample game
plyr_values <- c(4, 3, 2, 1)
comp_values <- c(1, 2, 3, 4)
game_results <- analyze_game(plyr_values, comp_values, nboot = 1000,
                             mode = "t", seed = 150)

}
