% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asinh_trans.R
\name{asinh_trans}
\alias{asinh_trans}
\title{Create an axis transform using the Inverse hyperbolic sine transformation}
\usage{
asinh_trans()
}
\value{
Adds a new transformation for use with ggplot
}
\description{
Create an axis transform using the Inverse hyperbolic sine transformation to allow log-like axis using data with negative values
}
\examples{
  
 library(ggplot2)
 ggplot(data.frame(x=seq(-1000,1000,len=200)), aes(x=x,y=x))+
 geom_line(size=1)+
 scale_x_continuous(trans = 'asinh',breaks=c(-1000,-100,10,-1,0,1,10,100,1000))
}
\references{
\url{http://wresch.github.io/2013/03/08/asinh-scales-in-ggplot2.html}

\url{http://robjhyndman.com/hyndsight/transformations/}

\url{http://stackoverflow.com/questions/14504869/histogram-with-negative-logarithmic-scale-in-r}
}

