% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORII.R
\name{covariateEffect_or2}
\alias{covariateEffect_or2}
\title{Covariate effect for Bayesian quantile regression for ordinal quantile model
with 3 outcomes}
\usage{
covariateEffect_or2(model, y, x, modX, gamma, p)
}
\arguments{
\item{model}{outcome of the ORII (quantreg_or2) model.}

\item{y}{observed ordinal outcomes, column vector of dimension \eqn{(n x 1)}.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones with or without column names.
If the covariate of interest is continuous, then the column for the covariate of interest remains unchanged.
If it is an indicator variable then replace the column for the covariate of interest with a
column of zeros.}

\item{modX}{matrix x with suitable modification to an independent variable including a column of ones with
or without column names. If the covariate of interest is continuous, then add the incremental change
to each observation in the column for the covariate of interest. If the covariate is an indicator variable,
then replace the column for the covariate of interest with a column of ones.}

\item{gamma}{one and only cut-point other than 0.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components:
\itemize{
\item{\code{avgDiffProb}: }{vector with change in predicted
probabilities for each outcome category.}
}
}
\description{
This function computes the average covariate effect for different
outcomes of the ORII model at the specified quantiles. The covariate
effects are calculated marginally of the parameters and the remaining covariates.
}
\details{
This function computes the average covariate effect for different
outcomes of the ORII model at the specified quantiles. The covariate
effects are calculated marginally of the parameters and the remaining covariates. The computation of covariate effects utilizes
the MCMC outputs from estimation.
}
\examples{
set.seed(101)
data("data25j3")
x <- data25j3$x
y <- data25j3$y
k <- dim(x)[2]
output <- quantreg_or2(y, x, b0 = 0, B0 = 10*diag(k), n0 = 5, d0 = 8, gamma = 3,
mcmc = 50, p = 0.25, display = FALSE)
modX <- x
modX[,3] <- modX[,3] + 0.02
res <- covariateEffect_or2(output, y, x, modX, gamma = 3, p = 0.25)

# Summary of Covariate Effect:

#               Covariate Effect
# Category_1          -0.0074
# Category_2          -0.0029
# Category_3           0.0104

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939

Jeliazkov, I., Graves, J., and Kutzbach, M. (2008). “Fitting and Comparison of Models
for Multivariate Ordinal Outcomes.” Advances in Econometrics: Bayesian Econometrics,
23: 115–156. DOI: 10.1016/S0731-9053(08)23004-5

Jeliazkov, I., and Rahman, M. A. (2012). “Binary and Ordinal Data Analysis
in Economics: Modeling and Estimation” in Mathematical Modeling with Multidisciplinary
Applications, edited by X.S. Yang, 123-150. John Wiley & Sons Inc, Hoboken, New Jersey. DOI: 10.1002/9781118462706.ch6
}
