% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/boot_global.R
\name{boot_global}
\alias{boot_global}
\title{Bootstrapping for global graph measures}
\usage{
boot_global(densities, resids, groups, R = 1000, measure = "mod")
}
\arguments{
\item{densities}{A vector of graph densities to loop through}

\item{resids}{A data.table of the residuals (from \code{\link{get.resid}})}

\item{groups}{A character vector indicating group names}

\item{R}{The number of bootstrap replicates (default: 1e3)}

\item{measure}{Character string of the measure to test (default: 'mod')}
}
\value{
A list with the following elements:
\item{g}{A list of \code{\link[boot]{boot}} objects}
\item{dt}{A data table with length \emph{# densities * # groups}}
\item{p1}{A ggplot object with ribbon representing standard error}
\item{p2}{A ggplot object with ribbon representing 95\% confidence interval}
}
\description{
This function performs bootstrapping to get group standard error estimates of
a global graph measure (e.g. modularity). It will output a list containing a
data table with standard errors and 95\% confidence intervals at each density
for each group, and 2 ggplot objects for plotting. This function is intended
for cortical thickness networks (in which there is only one graph per group),
but will obviously work in other scenarios.
}
\details{
The 95\% confidence intervals are calculated using the normal approximation.
}
\examples{
\dontrun{
boot.res <- boot_global(densities, m$resids, groups, 1e3, 'E.global')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link[boot]{boot}, \link[boot]{boot.ci},
\link{permute.group}}
}

